/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.temptable.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeListener;
import kd.bos.xdb.temptable.facade.TemptableFacadeTrappers;
import kd.bos.xdb.temptable.facade.TemptableType;

public class TemptableFacadeImpl
implements TemptableFacade {
    private final List<TemptableFacadeListener> listeners = new ArrayList<TemptableFacadeListener>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String name;
    private final TemptableType type;
    private Integer maxDataLength;
    private Collection<Object> data;

    TemptableFacadeImpl(long id, TemptableType type) {
        this.name = "@TMP_" + id;
        this.type = type;
        TemptableFacadeTrappers.trap(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TemptableType getType() {
        return this.type;
    }

    @Override
    public void insert(Collection<Object> pks) {
        if (this.data == null) {
            this.data = pks;
        } else {
            this.data.addAll(pks);
        }
        this.maxDataLength = null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (TemptableFacadeListener listener : this.listeners) {
                try {
                    listener.onClosed();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void addListener(TemptableFacadeListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public Collection<Object> getData() {
        return this.data;
    }

    @Override
    public int getMaxDataLength() {
        if (this.type != TemptableType.BIG_STRING) {
            return 0;
        }
        if (this.data == null) {
            return 0;
        }
        if (this.maxDataLength != null) {
            return this.maxDataLength;
        }
        int maxLength = 0;
        for (Object datum : this.data) {
            if (!(datum instanceof String)) continue;
            maxLength = Math.max(((String)datum).length(), maxLength);
        }
        this.maxDataLength = maxLength;
        return maxLength;
    }
}

