/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.temptable.manager;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.temptable.manager.Temptable;
import kd.bos.xdb.temptable.manager.TemptableReleaseListener;
import kd.bos.xdb.temptable.manager.TemptableService;

public final class TemptableFacadeResolver {
    private static final Pattern pattern = Pattern.compile("\\s@TMP_\\d+");
    private final TemptableService temptableService;
    private final TemptableFacadeContext context;
    private final IdentityHashMap<TemptableFacade, TemptableReleaseListener> listenerMap = new IdentityHashMap();
    private final HashMap<String, String> shareMap = new HashMap();

    public TemptableFacadeResolver(TemptableFacadeContext context, TemptableService temptableService) {
        this.context = context;
        this.temptableService = temptableService;
    }

    private TemptableFacade getFacade(String name) {
        TemptableFacade table = this.context.getTemptableFacadeByName(name);
        if (table != null) {
            return table;
        }
        throw new IllegalArgumentException("Can not match temptable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(String routeKey, String sql) {
        try {
            TemptableFacadeContexts._set(null);
            Matcher matcher = pattern.matcher(sql);
            StringBuffer newSql = new StringBuffer();
            while (matcher.find()) {
                String facadeName = matcher.group().trim();
                TemptableFacade temptableFacade = this.getFacade(facadeName);
                TemptableReleaseListener listener = this.listenerMap.computeIfAbsent(temptableFacade, facade -> {
                    TemptableReleaseListener l = new TemptableReleaseListener();
                    facade.addListener(l);
                    return l;
                });
                String temptableName = this.shareMap.computeIfAbsent(routeKey + "-" + facadeName, k -> {
                    Temptable temptable = this.temptableService.create(routeKey, temptableFacade.getType(), temptableFacade.getMaxDataLength());
                    listener.add(temptable);
                    temptable.insert(temptableFacade.getData());
                    return temptable.getName();
                });
                matcher.appendReplacement(newSql, ' ' + temptableName);
            }
            matcher.appendTail(newSql);
            String string = newSql.toString();
            return string;
        }
        finally {
            TemptableFacadeContexts._set(this.context);
        }
    }
}

