/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.cache.RollbackableCache;
import kd.bos.xdb.cache.global.GlobalCache;
import kd.bos.xdb.transaction.TransactionListener;

public final class XDBTransactionHook {
    private static final TransactionListener txCacheLifeCycleListener = new TransactionListener(){

        @Override
        public void onBegin() {
            CacheContext.get().createTXCache();
        }

        @Override
        public void onBeforeEnd(boolean rollbacked) {
            try (Cache cc = CacheContext.get().getCurrentCache();){
                if (rollbacked) {
                    if (cc instanceof GlobalCache) {
                        return;
                    }
                    ((RollbackableCache)((Object)cc)).setRollbacked(rollbacked);
                }
            }
        }
    };
    private static final Map<Long, List<TransactionListener>> hookMap = new ConcurrentHashMap<Long, List<TransactionListener>>();
    private static Supplier<Long> rootTXIdSupplier;
    private static final AtomicBoolean inited;

    public static boolean isInited() {
        return inited.get();
    }

    public static void init(Supplier<Long> rootTXIdSupplier) {
        if (inited.compareAndSet(false, true)) {
            XDBTransactionHook.rootTXIdSupplier = rootTXIdSupplier;
        }
    }

    private static List<TransactionListener> getTransactionListenerList(boolean createIfAbsent) {
        if (createIfAbsent) {
            Long key = rootTXIdSupplier.get();
            List<TransactionListener> ret = hookMap.get(key);
            if (ret == null) {
                return hookMap.computeIfAbsent(key, k -> new ArrayList());
            }
            return ret;
        }
        return hookMap.get(rootTXIdSupplier.get());
    }

    public static void addTransactionListener(TransactionListener l) {
        XDBTransactionHook.getTransactionListenerList(true).add(l);
    }

    public static void removeTransactionListener(TransactionListener l) {
        List<TransactionListener> list = XDBTransactionHook.getTransactionListenerList(false);
        if (list != null) {
            list.remove(l);
            if (list.isEmpty()) {
                hookMap.remove(rootTXIdSupplier.get());
            }
        }
    }

    public static void fireOnBegin() {
        txCacheLifeCycleListener.onBegin();
        List<TransactionListener> list = XDBTransactionHook.getTransactionListenerList(false);
        if (list != null && !list.isEmpty()) {
            for (TransactionListener l : list) {
                l.onBegin();
            }
        }
    }

    public static void fireOnBeforeEnd(boolean rollbacked) {
        List<TransactionListener> list = XDBTransactionHook.getTransactionListenerList(false);
        if (list != null && !list.isEmpty()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                list.get(i).onBeforeEnd(rollbacked);
            }
        }
        txCacheLifeCycleListener.onBeforeEnd(rollbacked);
    }

    public static void fireOnAfterEnd(boolean rollbacked) {
        List<TransactionListener> list = XDBTransactionHook.getTransactionListenerList(false);
        if (list != null && !list.isEmpty()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                list.get(i).onAfterEnd(rollbacked);
            }
        }
        txCacheLifeCycleListener.onAfterEnd(rollbacked);
    }

    static {
        inited = new AtomicBoolean();
    }
}

