/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ArrayUtil {
    public static final long[] EMPTY_INDEXIES = new long[0];

    public static long[] toArray(Collection<Long> vs) {
        int n = vs.size();
        if (n == 0) {
            return EMPTY_INDEXIES;
        }
        long[] ret = new long[n];
        int i = 0;
        for (Long v : vs) {
            ret[i++] = v;
        }
        return ret;
    }

    public static List<Object[]> split(Object[] pks, int batchSize) {
        if (pks.length <= batchSize) {
            return Collections.singletonList(pks);
        }
        int n = pks.length;
        ArrayList<Object[]> ret = new ArrayList<Object[]>(n / batchSize + 1);
        ArrayList<Object> list = new ArrayList<Object>(batchSize);
        for (int i = 0; i < n; ++i) {
            if (i % batchSize == 0 && i != 0) {
                ret.add(list.toArray());
                list.clear();
            }
            list.add(pks[i]);
        }
        if (!list.isEmpty()) {
            ret.add(list.toArray());
        }
        return ret;
    }

    public static String toParameterString(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        int len = Math.min(50, params.length);
        StringBuilder s = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            Object param;
            if (i > 0) {
                s.append(',');
            }
            if ((param = params[i]) instanceof String) {
                s.append('\'').append(param).append('\'');
                continue;
            }
            if (param != null && param.getClass().isArray()) {
                int plen = Array.getLength(param);
                int glen = Math.min(10, plen);
                s.append('[');
                for (int j = 0; j < glen; ++j) {
                    if (j > 0) {
                        s.append(',');
                    }
                    s.append(Array.get(param, j));
                }
                if (glen < plen) {
                    s.append("...(").append(plen).append(')');
                }
                s.append(']');
                continue;
            }
            s.append(param);
        }
        if (len < params.length) {
            s.append("...(").append(params.length).append(')');
        }
        return s.toString();
    }
}

