/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.util;

import kd.bos.xdb.sharding.strategy.ShardingValuesKey;

public final class HashCodeUtil {
    public static int getHashCode(Object[] values) {
        String shcode = ShardingValuesKey.key(values);
        int hcode = HashCodeUtil.hashAlgorithm(shcode);
        if (hcode == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Math.abs(hcode);
    }

    public static int getHashCodeSingle(Object value) {
        int hcode = HashCodeUtil.hashAlgorithm(String.valueOf(value));
        if (hcode == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Math.abs(hcode);
    }

    private static int hashAlgorithm(String s) {
        return s.hashCode();
    }

    public static long getHashMod(Object key, int mod) {
        int h = HashCodeUtil.getHashCode(new Object[]{key});
        int t = key == null ? 0 : h ^ h << 16;
        return mod - 1 & t;
    }
}

