/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.xdb.util.LRUCacheMap;

public class LRUCacheSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1067979492412317056L;
    private transient LRUCacheMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public LRUCacheSet(int initialCapacity, float loadFactor) {
        this.map = new LRUCacheMap(initialCapacity, loadFactor);
    }

    public LRUCacheSet(int initialCapacity) {
        this.map = new LRUCacheMap(initialCapacity, 0.5f);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            LRUCacheSet newSet = (LRUCacheSet)super.clone();
            newSet.map = (LRUCacheMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.getCacheSize());
        s.writeFloat(this.map.getLoadFactor());
        s.writeInt(this.map.size());
        for (Object e : this.map.keySet()) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        if (capacity < 0) {
            throw new InvalidObjectException("Illegal capacity: " + capacity);
        }
        float loadFactor = s.readFloat();
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + loadFactor);
        }
        int size = s.readInt();
        if (size < 0) {
            throw new InvalidObjectException("Illegal size: " + size);
        }
        capacity = (int)Math.min((float)size * Math.min(1.0f / loadFactor, 4.0f), 1.0737418E9f);
        this.map = new LRUCacheMap(capacity, loadFactor);
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }

    static final int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }
}

