/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.util;

import java.util.List;

public final class RingList<T> {
    private Object[] data;
    private final int len;
    private int first = -1;
    private int last = -1;
    private int size = 0;

    public RingList(int ringSize) {
        this.data = new Object[ringSize];
        this.len = ringSize;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(T value) {
        ++this.size;
        if (++this.last == this.len) {
            this.last = 0;
        }
        this.data[this.last] = value;
    }

    public void addAll(List<T> all) {
        for (T obj : all) {
            this.add(obj);
        }
    }

    public T removeFirst() {
        --this.size;
        if (++this.first == this.len) {
            this.first = 0;
        }
        Object obj = this.data[this.first];
        this.data[this.first] = null;
        return (T)obj;
    }

    public T peekFirst() {
        if (this.size == 0) {
            return null;
        }
        int i = this.first + 1;
        return (T)(i == this.len ? this.data[0] : this.data[i]);
    }

    public T getFirst() {
        return this.peekFirst();
    }

    public T getLast() {
        return (T)this.data[this.last];
    }

    public void clear() {
        this.size = 0;
        this.first = -1;
        this.last = -1;
        for (int i = 0; i < this.len; ++i) {
            this.data[i] = null;
        }
    }

    public void copyData(RingList<T> all) {
        System.arraycopy(all.data, 0, this.data, 0, all.len);
        this.size = all.size;
        this.first = all.first;
        this.last = all.last;
    }

    public void copyDataAndClear(RingList<T> all) {
        if (this.size > 0) {
            for (int i = 0; i < this.len; ++i) {
                this.data[i] = null;
            }
        }
        Object[] buf = this.data;
        this.data = all.data;
        all.data = buf;
        this.size = all.size;
        this.first = all.first;
        this.last = all.last;
        all.size = 0;
        all.first = -1;
        all.last = -1;
    }
}

