/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.config;

import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.xpm.exporter.ExporterType;
import kd.bos.xdb.xpm.exporter.alarm.AlarmType;

public final class XpmConfig {
    private static boolean enabled = false;
    private static boolean ignoreCollectorAll = true;
    private static boolean filterShardingQuery = true;
    private static boolean alarmEnabled = true;
    private static int alarmShardingTableCount = 5;
    private static int alarmTotalSpent = 5000;
    private static boolean executeError = false;
    private static boolean updateShardingField = true;
    private static boolean distinctSqlMetric = false;
    private static boolean exportLogEachMetrics = false;
    private static int exportQueue = 10000;
    private static int exportInterval = 60000;
    private static ExporterType exportType = ExporterType.dummy;
    private static AlarmType alarmType = AlarmType.bill;
    private static boolean enableMetricClean = true;
    private static long topRemain = 100000L;
    private static int cleanInterval = 60;

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isIgnoreCollectorAll() {
        return ignoreCollectorAll;
    }

    public static boolean isFilterShardingQuery() {
        return filterShardingQuery;
    }

    public static boolean isAlarmEnabled() {
        return alarmEnabled;
    }

    public static int getAlarmShardingTableCount() {
        return alarmShardingTableCount;
    }

    public static int getAlarmTotalSpent() {
        return alarmTotalSpent;
    }

    public static boolean isAlarmExecuteError() {
        return executeError;
    }

    public static boolean isAlarmupdateShardingField() {
        return updateShardingField;
    }

    public static boolean isAlarmDistinctSqlMetric() {
        return distinctSqlMetric;
    }

    public static boolean isExportLogEachMetrics() {
        return exportLogEachMetrics;
    }

    public static int getExportQueue() {
        return exportQueue;
    }

    public static long getExportInterval() {
        return exportInterval;
    }

    public static ExporterType getExportType() {
        return exportType;
    }

    public static AlarmType getAlarmType() {
        return alarmType;
    }

    public static void setAlarmType(AlarmType alarmType) {
        XpmConfig.alarmType = alarmType;
    }

    public static boolean isEnableMetricClean() {
        return enableMetricClean;
    }

    public static long getTopRemain() {
        return topRemain;
    }

    public static int getCleanInterval() {
        return cleanInterval;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.enable", (boolean)enabled, v -> {
            enabled = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.ignoreCollectorAll", (boolean)ignoreCollectorAll, v -> {
            ignoreCollectorAll = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.filter.onlyShardingQuery", (boolean)filterShardingQuery, v -> {
            filterShardingQuery = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.alarm.enable", (boolean)alarmEnabled, v -> {
            alarmEnabled = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.xpm.alarm.shardingTableCount", (int)alarmShardingTableCount, v -> {
            alarmShardingTableCount = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.xpm.alarm.totalSpent", (int)alarmTotalSpent, v -> {
            alarmTotalSpent = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.alarm.executeError", (boolean)executeError, v -> {
            executeError = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.alarm.updateShardingField", (boolean)updateShardingField, v -> {
            updateShardingField = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.alarm.distinctSqlMetric", (boolean)distinctSqlMetric, v -> {
            distinctSqlMetric = v;
        });
        ConfigurationUtil.observeString((String)"xdb.xpm.alarm.type", (String)alarmType.name(), v -> {
            try {
                alarmType = AlarmType.valueOf(v);
            }
            catch (Exception e) {
                alarmType = AlarmType.bill;
            }
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.export.logEachMetrics", (boolean)exportLogEachMetrics, v -> {
            exportLogEachMetrics = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.xpm.export.queue", (int)exportQueue, v -> {
            exportQueue = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.xpm.export.interval", (int)exportInterval, v -> {
            exportInterval = v;
        });
        ConfigurationUtil.observeString((String)"xdb.xpm.export.type", (String)exportType.name(), v -> {
            try {
                exportType = ExporterType.valueOf(v);
            }
            catch (Exception e) {
                exportType = ExporterType.dummy;
            }
        });
        ConfigurationUtil.observeBoolean((String)"xdb.xpm.clean.enable", (boolean)enableMetricClean, v -> {
            enableMetricClean = v;
        });
        ConfigurationUtil.observeLong((String)"xdb.xpm.clean.topRemain", (long)topRemain, v -> {
            topRemain = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.xpm.clean.interval", (int)cleanInterval, v -> {
            cleanInterval = v;
        });
    }
}

