/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.exporter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.xpm.config.XpmConfig;
import kd.bos.xdb.xpm.exporter.Exporter;
import kd.bos.xdb.xpm.exporter.ExporterFactory;
import kd.bos.xdb.xpm.exporter.ExporterType;
import kd.bos.xdb.xpm.exporter.alarm.Alarms;
import kd.bos.xdb.xpm.exporter.filter.Filters;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.export.MetricsFormatter;
import kd.bos.xdb.xpm.metrics.export.QueryStatMetrics;

public final class ExporterService
implements Runnable,
XDBLogable {
    private static List list = new ArrayList(XpmConfig.getExportQueue() + 32);

    public static void start() {
        Thread t = new Thread((Runnable)new ExporterService(), "XDB-XPM-ExporterService");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportMetrics(Metrics metrics) {
        if (!Filters.filter(metrics)) {
            return;
        }
        if (XpmConfig.isExportLogEachMetrics() && log.isInfoEnabled()) {
            log.info(MetricsFormatter.format(metrics));
        }
        Alarms.alarm(metrics);
        if (XpmConfig.getExportType() != ExporterType.dummy) {
            int size = list.size();
            if (size < XpmConfig.getExportQueue()) {
                List list = ExporterService.list;
                synchronized (list) {
                    ExporterService.list.add(metrics);
                }
            }
            List list = ExporterService.list;
            synchronized (list) {
                ExporterService.list.notifyAll();
            }
            if (log.isWarnEnabled()) {
                log.warn("XPM discard metrics cause export queue is full(" + size + ">=" + XpmConfig.getExportQueue() + "): " + metrics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exporter exporter = ExporterFactory.createExporter();
        ArrayList<Metrics> ret = new ArrayList<Metrics>(16);
        while (!Thread.currentThread().isInterrupted()) {
            ArrayList segs;
            List list = ExporterService.list;
            synchronized (list) {
                try {
                    ExporterService.list.wait(XpmConfig.getExportInterval());
                }
                catch (InterruptedException e) {
                    break;
                }
                segs = new ArrayList(ExporterService.list);
                ExporterService.list.clear();
            }
            if (segs.isEmpty()) continue;
            try {
                long xpmId = IDUtil.id();
                QueryStatMetrics summary = new QueryStatMetrics();
                ret.add(summary);
                for (Metrics toMerge : segs) {
                    boolean merged = false;
                    for (Metrics m : ret) {
                        if (!m.merge(toMerge)) continue;
                        merged = true;
                        break;
                    }
                    if (merged) continue;
                    ret.add(toMerge);
                }
                if (summary.getMerged() == 0) {
                    ret.set(0, null);
                } else if (summary.getMerged() > 1) {
                    ret.add(summary.calcAvgMetrics());
                }
                exporter.beforeExport(xpmId);
                for (Metrics m : ret) {
                    if (m == null) continue;
                    exporter.export(xpmId, m);
                }
                exporter.afterExport(xpmId);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("XPM export error, loss " + ret.size() + ": " + e.getMessage(), (Throwable)e);
            }
            finally {
                ret.clear();
                ThreadLocals.release();
            }
        }
    }
}

