/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.exporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.xpm.exporter.Exporter;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.export.MetricsFormatter;

final class StdOutExporter
implements Exporter {
    private Map<Long, List<Metrics>> mmap = new ConcurrentHashMap<Long, List<Metrics>>();

    StdOutExporter() {
    }

    @Override
    public void beforeExport(long xpmId) {
        this.mmap.put(xpmId, new ArrayList(2));
    }

    @Override
    public void export(long xpmId, Metrics metrics) {
        List<Metrics> list = this.mmap.get(xpmId);
        if (list != null) {
            list.add(metrics);
        }
    }

    @Override
    public void afterExport(long xpmId) {
        List<Metrics> list = this.mmap.remove(xpmId);
        if (list != null) {
            System.out.println(MetricsFormatter.format(xpmId, list));
        }
    }
}

