/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.exporter.alarm;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.util.LRUCacheMap;
import kd.bos.xdb.util.LRUCacheSet;
import kd.bos.xdb.xpm.config.XpmConfig;
import kd.bos.xdb.xpm.exporter.alarm.Alarm;
import kd.bos.xdb.xpm.exporter.alarm.stack.MetricStack;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.export.QueryMetrics;
import kd.bos.xdb.xpm.metrics.performance.MetricFlagEnum;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

class BosBillAlarm
implements Alarm,
XDBLogable {
    private static final Map<String, Set<MetricStack>> cacheMap = Collections.synchronizedMap(new LRUCacheMap(500));
    private static final String insertSql = KSQL.dialect(NoShardingHint.genNoShardingSQL("insert into t_cbs_shard_metric(fid,fbillnumber,ftraceid,fstack,fcreatetime,fmetricstype) values (?,?,?,?,?,?)"));
    private static final String querySql = KSQL.dialect(NoShardingHint.genNoShardingSQL("select fsql,fmainstack from t_cbs_shard_metric_main"));
    private static final String insertMainSql = KSQL.dialect(NoShardingHint.genNoShardingSQL("insert into t_cbs_shard_metric_main(fid,fbillnumber,fsql,fmetricflag,fmetricstype,fmainstack,fstack,ftimes,fcreatetime,fmodifytime) values (?,?,?,?,?,?,?,?,?,?)"));
    private static final String updateMainSql = KSQL.dialect(NoShardingHint.genNoShardingSQL("update t_cbs_shard_metric_main set ftimes = ftimes+1,fmodifytime=? where fsql = ? and fmainstack=?"));
    static BosBillAlarm INSTANCE = new BosBillAlarm();

    private BosBillAlarm() {
        if (XpmConfig.isAlarmDistinctSqlMetric()) {
            this.init();
        }
    }

    @Override
    public void alarm(Metrics metrics) {
        PerformanceMetric pm;
        String callStack;
        QueryMetrics m;
        if (metrics instanceof QueryMetrics && (m = (QueryMetrics)metrics).isPerformanceMetricEnabled() && m.getSQLFeature().isSharding() && (callStack = (pm = m.getPerformanceMetric()).getCallStack()) != null) {
            long id = IDUtil.id();
            String stack = "[alarm] " + metrics + '\n' + callStack;
            String billNumber = pm.getBillNumber();
            String traceId = m.getSQLFeature().getTraceId();
            if (!XpmConfig.isAlarmDistinctSqlMetric()) {
                try (XDBExternal xe = XDBExternal.requiresNew("alarm");){
                    xe.execute("sys", insertSql, new Object[]{id, billNumber, traceId, stack, new Date(), "0"});
                }
                catch (Exception e) {
                    log.error("BosBillAlarm insert error:" + e.getMessage(), (Throwable)e);
                }
            } else {
                String mSql = m.getSQLFeature().getSql();
                if (Objects.nonNull(mSql)) {
                    MetricFlagEnum metricFlag = pm.getMetricFlag();
                    MetricStack metricStack = new MetricStack(mSql, stack, false);
                    Set<MetricStack> metricStacks = cacheMap.get(mSql);
                    if (metricStacks == null || !metricStacks.contains(metricStack)) {
                        try (XDBExternal xe = XDBExternal.requiresNew("alarm");){
                            xe.execute("sys", insertMainSql, new Object[]{id, billNumber, mSql, metricFlag.getMetricFlag(), "0", metricStack.getMainStack(), stack, 1, new Date(), new Date()});
                        }
                        catch (Exception e) {
                            log.error("BosBillAlarm insert error:" + e.getMessage(), (Throwable)e);
                        }
                    } else {
                        try (XDBExternal xe = XDBExternal.requiresNew("alarm");){
                            xe.execute("sys", updateMainSql, new Object[]{new Date(), metricStack.getSql(), metricStack.getMainStack()});
                        }
                        catch (Exception e) {
                            log.error("BosBillAlarm update error:" + e.getMessage(), (Throwable)e);
                        }
                    }
                    cacheMap.computeIfAbsent(mSql, k -> new LRUCacheSet(20)).add(metricStack);
                }
            }
        }
    }

    private void init() {
        try (XDBExternal xe = XDBExternal.requiresNew("alarm");){
            xe.query("sys", querySql, null, rs -> {
                try {
                    while (rs.next()) {
                        String sql = rs.getString("fsql");
                        String mainStack = rs.getString("fmainstack");
                        cacheMap.computeIfAbsent(sql, k -> new LRUCacheSet(20)).add(new MetricStack(sql, mainStack));
                    }
                }
                catch (SQLException e) {
                    log.error("BosBillAlarm init cacheMap error:" + e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("BosBillAlarm query metricStack error:" + e.getMessage(), (Throwable)e);
        }
    }
}

