/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.action.ActionSpan;
import kd.bos.xdb.xpm.metrics.action.MessageSpan;

public class ActionMetric
implements Metrics {
    private Set<String> shardingTables = new HashSet<String>();
    private int missParseCacheTimes;
    private int hitParseCacheTimes;
    private int parseSQLTimes;
    private int parseSQLExtractParameterTimes;
    private int parseSQLExtractNewParameterCount;
    private List<ActionSpan> statList = new LinkedList<ActionSpan>();

    public void stat(ActionSpan ss) {
        this.statList.add(ss);
    }

    public void stat(String msg) {
        this.statList.add(new MessageSpan(msg));
    }

    public List<ActionSpan> getActionSpanList() {
        return Collections.unmodifiableList(new ArrayList<ActionSpan>(this.statList));
    }

    public Set<String> getShardingTables() {
        return this.shardingTables;
    }

    public int getMissParseCacheTimes() {
        return this.missParseCacheTimes;
    }

    public void incMissParseCacheTimes() {
        ++this.missParseCacheTimes;
    }

    public int getHitParseCacheTimes() {
        return this.hitParseCacheTimes;
    }

    public void incHitParseCacheTimes() {
        ++this.hitParseCacheTimes;
    }

    public int getParseSQLTimes() {
        return this.parseSQLTimes;
    }

    public void incParseSQLTimes() {
        ++this.parseSQLTimes;
    }

    public int getParseSQLExtractParameterTimes() {
        return this.parseSQLExtractParameterTimes;
    }

    public void incParseSQLExtractParameterTimes() {
        ++this.parseSQLExtractParameterTimes;
    }

    public int getParseSQLExtractNewParameterCount() {
        return this.parseSQLExtractNewParameterCount;
    }

    public void incParseSQLExtractNewParameterCount(int parseSQLExtractNewParameterCount) {
        this.parseSQLExtractNewParameterCount += parseSQLExtractNewParameterCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096).append("[ActionMetric]");
        if (!this.shardingTables.isEmpty()) {
            ShardingConfigProvider scp = XDBConfig.getShardingConfigProvider();
            ArrayList<String> tables = new ArrayList<String>(this.shardingTables);
            tables.sort((t1, t2) -> {
                int dt = scp.getConfig((String)t1).getLevel() - scp.getConfig((String)t2).getLevel();
                if (dt == 0) {
                    dt = t1.compareTo((String)t2);
                }
                return dt;
            });
            ArrayList<String> tableInfos = new ArrayList<String>(this.shardingTables.size());
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                ShardingConfig config;
                String table;
                String line = table = (String)iterator.next();
                String aliasName = TableName.of(table).getAliasName();
                if (!aliasName.equals(table)) {
                    line = line + '/' + aliasName;
                }
                if ((config = scp.getConfig(table)) instanceof MainTableConfig) {
                    line = line + '#' + Arrays.asList(config.getShardingFields()).toString();
                }
                tableInfos.add(line);
            }
            sb.append("\n\t").append("shardingTables(").append(this.shardingTables.size()).append("): ").append(tableInfos);
        }
        if (this.missParseCacheTimes > 0) {
            sb.append("\n\t").append("missParseCacheTimes: ").append(this.missParseCacheTimes);
        }
        if (this.hitParseCacheTimes > 0) {
            sb.append("\n\t").append("hitParseCacheTimes: ").append(this.hitParseCacheTimes);
        }
        if (this.parseSQLTimes > 0) {
            sb.append("\n\t").append("parseSQLTimes: ").append(this.parseSQLTimes);
        }
        if (this.parseSQLExtractParameterTimes > 0) {
            sb.append("\n\t").append("parseSQLExtractParameterTimes: ").append(this.parseSQLExtractParameterTimes);
        }
        if (this.parseSQLExtractNewParameterCount > 0) {
            sb.append("\n\t").append("parseSQLExtractNewParameterCount: ").append(this.parseSQLExtractNewParameterCount);
        }
        sb.append("\n\t").append("actions(").append(this.statList.size()).append("):");
        int c = 0;
        for (ActionSpan span : this.statList) {
            sb.append("\n\t\t").append(++c).append('#').append(span.toString().replaceAll("\n", "\n\t\t"));
        }
        return sb.toString();
    }
}

