/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.inspector;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.KDExceptionKit;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.Token;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.hint.ExtractHeadCommentAndTrim;
import kd.bos.xdb.hint.HintUtil;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.inspector.XDBInspectResult;
import kd.bos.xdb.xpm.metrics.listener.MetricsListener;
import kd.bos.xdb.xpm.metrics.listener.MetricsListenerContext;

public final class XDBInspector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XDBInspectResult inspect(String dbRoute, String sql, Object[] params) {
        boolean select;
        block50: {
            select = false;
            try (MetricsCollector mc = MetricsCollector.createCollector();){
                ExtractHeadCommentAndTrim ec = new ExtractHeadCommentAndTrim(mc);
                ec.extract(sql);
                if (!mc.sqlFeature().isDialect()) {
                    SQLStatement stmt = SQLParser.parse1_stmt(sql);
                    if (stmt instanceof SQLSelectStatement) {
                        select = true;
                    } else if (stmt instanceof SQLDDLStatement) {
                        throw new UnsupportedOperationException("Unsupport inspect sql: " + sql);
                    }
                    break block50;
                }
                Lexer lexer = new Lexer(sql, true);
                try {
                    Token t = lexer.next();
                    while (t.type == 0 || t.type == 14) {
                        t = lexer.next();
                    }
                    if ("select".equals(t.value.toLowerCase())) {
                        select = true;
                    }
                }
                catch (Exception e) {
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
            }
        }
        final XDBInspectResult ret = new XDBInspectResult();
        MetricsListener l = new MetricsListener(){

            @Override
            public void onExecuted(List<String> allSQL, MetricsCollector ... mcs) {
                ret.setAllSQL(allSQL);
                ret.setMetricsCollectors(mcs);
            }
        };
        try (XDBExternal xe = XDBExternal.requiresNew("xdb-inspector");
             MetricsListenerContext ctx = MetricsListenerContext.createAndSet(l);){
            sql = HintUtil.addMetricsHint(sql, true, true);
            try {
                if (select) {
                    xe.query(dbRoute, sql, params, rs -> {});
                } else {
                    xe.execute(dbRoute, sql, params);
                }
            }
            finally {
                xe.markRollback();
            }
        }
        if (ret.getMetricsCollectors() == null) {
            ret.setAllSQL(Collections.singletonList(sql));
            ret.setMetricsCollectors(new MetricsCollector[]{MetricsCollector.getCurrent()});
        }
        return ret;
    }
}

