/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.listener;

import java.util.List;
import java.util.function.Function;
import kd.bos.xdb.xpm.exporter.filter.Filters;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.listener.MetricsListener;

public abstract class AbstractMetricsListener
implements MetricsListener {
    private Function<String, String> replaceLineFunc;

    public AbstractMetricsListener(String linePrefix) {
        this.replaceLineFunc = linePrefix == null || linePrefix.length() == 0 ? s -> s : s -> linePrefix + AbstractMetricsListener.replace(s, "\n", "\n" + linePrefix);
    }

    @Override
    public void onExecuted(List<String> allSQL, MetricsCollector ... mcs) {
        boolean hasOut = false;
        for (MetricsCollector mc : mcs) {
            if (!Filters.filter(mc.sqlFeature())) continue;
            if (!hasOut) {
                this.beforeMetrics();
                hasOut = true;
            }
            this.onEachMetrics(this.replaceLineFunc.apply(mc.toString()));
        }
        if (hasOut) {
            this.afterMetrics();
            if (!allSQL.isEmpty()) {
                this.beforeSQL();
                for (String sql : allSQL) {
                    this.onEachSQL(this.replaceLineFunc.apply(sql));
                }
                this.afterSQL();
            }
        }
    }

    protected void beforeMetrics() {
    }

    protected abstract void onEachMetrics(String var1);

    protected void afterMetrics() {
    }

    protected void beforeSQL() {
    }

    protected abstract void onEachSQL(String var1);

    protected void afterSQL() {
    }

    private static String replace(String inString, String oldPattern, String newPattern) {
        if (!AbstractMetricsListener.hasLength(inString) || !AbstractMetricsListener.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }
}

