/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.listener;

import kd.bos.util.ThreadLocals;
import kd.bos.xdb.xpm.metrics.listener.MetricsListener;

public class MetricsListenerContext
implements AutoCloseable {
    private static ThreadLocal<MetricsListenerContext> th = ThreadLocals.create();
    private static MetricsListener globalMetricsListener;
    private final MetricsListener listener;

    public static MetricsListenerContext createAndSet(MetricsListener listener) {
        return new MetricsListenerContext(listener);
    }

    public static MetricsListenerContext get() {
        return th.get();
    }

    public static MetricsListener getGlobalMetricsListener() {
        return globalMetricsListener;
    }

    public static void setGlobalMetricsListener(MetricsListener globalMetricsListener) {
        MetricsListenerContext.globalMetricsListener = globalMetricsListener;
    }

    private MetricsListenerContext(MetricsListener listener) {
        this.listener = listener;
        th.set(this);
    }

    public MetricsListener getMetricsListener() {
        return this.listener;
    }

    @Override
    public void close() {
        th.remove();
    }
}

