/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.performance;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.performance.MetricFlagEnum;

public class PerformanceMetric
implements Metrics {
    private MetricFlagEnum metricFlag;
    private String billNumber;
    private long totalSpent;
    private long parseSpent;
    private long shardingSpent;
    private long executeSpent;
    private long mergeSpent;
    private int shardingSQLCount;
    private int parallelQuery = 1;
    private boolean usePK;
    private boolean useIndex;
    private boolean useHint;
    private boolean partShardingCondition;
    private boolean fullShardingCondition;
    private boolean updateShardingField;
    private boolean executeError;
    private String callStack;

    public boolean isUseHint() {
        return this.useHint;
    }

    public void setUseHint(boolean useHint) {
        this.useHint = useHint;
    }

    public boolean isFullShardingCondition() {
        return this.fullShardingCondition;
    }

    public void setFullShardingCondition(boolean fullShardingCondition) {
        this.fullShardingCondition = fullShardingCondition;
    }

    public boolean isUsePK() {
        return this.usePK;
    }

    public void setUsePK(boolean usePK) {
        this.usePK = usePK;
    }

    public boolean isUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(boolean useIndex) {
        this.useIndex = useIndex;
    }

    public boolean isPartShardingCondition() {
        return this.partShardingCondition;
    }

    public void setPartShardingCondition(boolean partShardingCondition) {
        this.partShardingCondition = partShardingCondition;
    }

    public MetricFlagEnum getMetricFlag() {
        return this.metricFlag;
    }

    public void setMetricFlag(MetricFlagEnum metricFlag) {
        this.metricFlag = metricFlag;
    }

    public boolean isUpdateShardingField() {
        return this.updateShardingField;
    }

    public void setUpdateShardingField(boolean updateShardingField) {
        this.updateShardingField = updateShardingField;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public long getParseSpent() {
        return this.parseSpent;
    }

    public void incParseSpent(long parseSpent) {
        this.parseSpent += parseSpent;
    }

    public long getShardingSpent() {
        return this.shardingSpent;
    }

    public void incShardingSpent(long shardingSpent) {
        this.shardingSpent += shardingSpent;
    }

    public long getExecuteSpent() {
        return this.executeSpent;
    }

    public void setExecuteSpent(long executeSpent) {
        this.executeSpent = executeSpent;
    }

    public long getMergeSpent() {
        return this.mergeSpent;
    }

    public void setMergeSpent(long mergeSpent) {
        this.mergeSpent = mergeSpent;
    }

    public int getShardingSQLCount() {
        return this.shardingSQLCount;
    }

    public void setShardingSQLCount(int shardingSQLCount) {
        this.shardingSQLCount = shardingSQLCount;
    }

    public int getParallelQuery() {
        return this.parallelQuery;
    }

    public void setParallelQuery(int parallelQuery) {
        this.parallelQuery = parallelQuery;
    }

    public boolean isExecuteError() {
        return this.executeError;
    }

    public void setExecuteError(boolean executeError) {
        this.executeError = executeError;
    }

    public long getTotalSpent() {
        return this.totalSpent;
    }

    public void setTotalSpent(long totalSpent) {
        this.totalSpent = totalSpent;
    }

    public String getCallStack() {
        return this.callStack;
    }

    public final void logCallStack(String msg) {
        StringBuilder sb = new StringBuilder(msg.length() + 5120).append("[XPM] ").append(msg).append('\n');
        StringWriter sw = new StringWriter(10240);
        new Exception().printStackTrace(new PrintWriter(sw));
        String stack = sw.toString();
        int end = stack.indexOf("at kd.bos.service.web");
        if (end > 21) {
            sb.append(stack, 21, end).append("\n\t...");
        } else {
            sb.append(stack.substring(21)).append("\n\t...");
        }
        this.callStack = this.callStack == null ? sb.toString() : this.callStack + "\n------------------------\n" + sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256).append("[PerformanceMetric]");
        String switchLine = "\n\t";
        if (this.metricFlag != null) {
            sb.append(switchLine).append("warn: ").append((Object)this.metricFlag);
        }
        if (this.billNumber != null) {
            sb.append(switchLine).append("billNumber: ").append(this.billNumber);
        }
        sb.append(switchLine).append("totalSpent: ").append(this.totalSpent);
        sb.append(switchLine).append("parseSpent: ").append(this.parseSpent);
        sb.append(switchLine).append("shardingSpent: ").append(this.shardingSpent);
        sb.append(switchLine).append("executeSpent: ").append(this.executeSpent);
        sb.append(switchLine).append("parallelQuery: ").append(this.parallelQuery);
        sb.append(switchLine).append("shardingSQLCount: ").append(this.shardingSQLCount);
        if (this.usePK) {
            sb.append(switchLine).append("usePK: true");
        }
        if (this.useIndex) {
            sb.append(switchLine).append("useIndex: true");
        }
        if (this.useHint) {
            sb.append(switchLine).append("useHint: true");
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (this.partShardingCondition) {
            actions.add("partShardingCondition");
        }
        if (this.fullShardingCondition) {
            actions.add("fullShardingCondition");
        }
        if (this.updateShardingField) {
            actions.add("updateShardingField");
        }
        if (this.executeError) {
            actions.add("executeError");
        }
        if (!actions.isEmpty()) {
            sb.append(switchLine).append("actions: ").append(actions);
        }
        return sb.toString();
    }
}

