/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kd.bos.logorm.codec.CodecFactory;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;

public class ConditionSqlBuilder {
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> params = new ArrayList<Object>();
    private final AtomicBoolean hasInit = new AtomicBoolean(false);
    private final QFilter qFilter;
    private final boolean isDb;
    private final Calendar calendar;

    public ConditionSqlBuilder(QFilter qFilter, boolean isDb, Calendar calendar) {
        this.qFilter = qFilter;
        this.isDb = isDb;
        this.calendar = calendar;
    }

    public void init() {
        if (this.hasInit.compareAndSet(false, true)) {
            this.filter2String(this.qFilter);
        }
    }

    private void filter2String(QFilter qFilter) {
        this.appendSql(qFilter);
        this.appendParam(qFilter);
        List nests = qFilter.getNests(false);
        if (!nests.isEmpty()) {
            this.resloveNests(nests, nest -> {
                this.sql.append(' ').append(nest.getOp()).append(' ');
                this.filter2String(nest.getFilter());
                return null;
            });
        }
    }

    private void resloveNests(List<QFilter.QFilterNest> nests, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            this.sql.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest nest : nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    this.sql.insert(0, '(');
                    this.sql.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            this.sql.append(')');
        }
    }

    private void appendSql(QFilter qFilter) {
        this.sql.append(this.genSql(qFilter));
    }

    private void appendParam(QFilter qFilter) {
        if (qFilter.getCP().equalsIgnoreCase("in") || qFilter.getCP().equalsIgnoreCase("not in")) {
            QParameter inQP = QFilterUtil.getInQParameter((Object)qFilter.getValue(), (boolean)false);
            if (inQP != null) {
                this.params.addAll(Arrays.asList(inQP.getParameters()));
            }
        } else {
            this.params.add(qFilter.getValue());
        }
    }

    private String genSql(QFilter qFilter) {
        if (qFilter.isExpressValue()) {
            throw LogORMExceptionFactory.createWithContext("Not supported qfilter express value:%s .", qFilter.toString());
        }
        switch (qFilter.getCP().toLowerCase()) {
            case "=": 
            case ">": 
            case "<": 
            case ">=": 
            case "<=": 
            case "!=": 
            case "<>": 
            case "like": 
            case "not like": {
                return qFilter.getProperty() + ' ' + qFilter.getCP() + (this.isDb ? " ?" : ' ' + this.encodeElasticValueAsText(qFilter.getValue()));
            }
            case "is null": {
                return qFilter.getProperty() + ' ' + "is null";
            }
            case "is not null": {
                return qFilter.getProperty() + ' ' + "is not null";
            }
            case "in": 
            case "not in": {
                QParameter inQP = QFilterUtil.getInQParameter((Object)qFilter.getValue(), (boolean)false);
                if (inQP == null) {
                    return "in".equalsIgnoreCase(qFilter.getCP()) ? "1 != 1" : "1 = 1";
                }
                if (inQP.getParameters().length == 1) {
                    return qFilter.getProperty() + ' ' + (qFilter.getCP().equalsIgnoreCase("in") ? "=" : "!=") + (this.isDb ? " ?" : ' ' + this.encodeElasticValueAsText(inQP.getParameters()[0]));
                }
                StringBuilder sb = new StringBuilder();
                sb.append(qFilter.getProperty()).append(' ').append(qFilter.getCP()).append("(");
                ArrayList<String> p = new ArrayList<String>(inQP.getParameters().length);
                for (int i = 0; i < inQP.getParameters().length; ++i) {
                    if (this.isDb) {
                        p.add("?");
                        continue;
                    }
                    p.add(this.encodeElasticValueAsText(inQP.getParameters()[i]));
                }
                sb.append(String.join((CharSequence)",", p));
                sb.append(')');
                return sb.toString();
            }
        }
        throw LogORMExceptionFactory.createWithContext("Unsupported qcp: %s .", qFilter.getCP());
    }

    public String getSql() {
        this.init();
        return this.sql.toString();
    }

    public List<Object> getParams() {
        this.init();
        return this.params;
    }

    private String encodeElasticValueAsText(Object value) {
        if (value instanceof String) {
            value = this.escapeSingleQuotes((String)value);
        }
        return CodecFactory.get(value).encodeAsText(value, this.calendar);
    }

    private String escapeSingleQuotes(String str) {
        StringBuilder buffer = new StringBuilder(str);
        int count = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) == '\'') {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            if (count % 2 != 0) {
                buffer.insert(i, '\'');
            }
            count = 0;
        }
        if (count > 0 && count % 2 != 0) {
            buffer.insert(buffer.length() - 1, '\'');
        }
        return buffer.toString();
    }
}

