/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.bundle.BosRes;
import kd.bos.db.RequestContextInfo;
import kd.bos.logorm.client.BulkResponse;
import kd.bos.logorm.client.Client;
import kd.bos.logorm.client.DeleteByQueryResponse;
import kd.bos.logorm.client.QueryCompletionResponse;
import kd.bos.logorm.client.es.BatchSaveAction;
import kd.bos.logorm.client.es.DeleteAction;
import kd.bos.logorm.client.es.ESQueryCompletionResponse;
import kd.bos.logorm.client.es.IndexExistManager;
import kd.bos.logorm.client.es.QueryAction;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.datasource.es.RestClientFactory;
import kd.bos.logorm.exception.LogORMException;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.exception.es.CharacterNotSupportedException;
import kd.bos.logorm.exception.es.IndexNotFoundException;
import kd.bos.logorm.exception.es.SqlParseException;
import kd.bos.logorm.request.BatchSaveRequest;
import kd.bos.logorm.request.DeleteRequest;
import kd.bos.logorm.request.QueryRequest;
import kd.bos.logorm.request.RequestContext;

public class ElasticSearchClient
implements Client {
    @Override
    public QueryCompletionResponse query(RequestContext context, QueryRequest request) {
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        ESDataSource datasource = RestClientFactory.getClient(tenantId, accountId);
        try {
            return (QueryCompletionResponse)new QueryAction(context, datasource, request, tenantId, accountId).execute();
        }
        catch (IndexNotFoundException ex) {
            if (!datasource.isArchive()) {
                IndexExistManager.asyncCreateMappingIfNotExist(context, datasource, tenantId, accountId, request.getTable(), request.getEntityName(), new Date());
            }
            ESQueryCompletionResponse rs = ESQueryCompletionResponse.emptyResult(request.getEntityName(), context, request, tenantId, accountId);
            DataSet ds = Algo.create((String)"LogORM").createDataSet((Iterator)rs.getRowResult(), rs.getRowMeta());
            return new QueryCompletionResponse(ds);
        }
        catch (Exception ex) {
            throw this.wrapperException(ex);
        }
    }

    @Override
    public BulkResponse bulk(RequestContext context, BatchSaveRequest request) {
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        ESDataSource datasource = RestClientFactory.getClient(tenantId, accountId);
        HashSet<Date> dates = new HashSet<Date>(request.getOptDate());
        if (datasource.isArchive()) {
            throw LogORMExceptionFactory.createWithContext("Can not save data in archive datasource.");
        }
        dates.forEach(date -> IndexExistManager.createMappingIfNotExist(context, datasource, tenantId, accountId, request.getTable(), request.getEntityName(), date));
        try {
            return (BulkResponse)new BatchSaveAction(context, datasource, request, tenantId, accountId).execute();
        }
        catch (Exception ex) {
            throw this.wrapperException(ex);
        }
    }

    @Override
    public DeleteByQueryResponse delete(RequestContext context, DeleteRequest request) {
        String accountId;
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        ESDataSource datasource = RestClientFactory.getClient(tenantId, accountId = rc.getAccountId());
        if (datasource.isArchive()) {
            throw LogORMExceptionFactory.createWithContext("Can not delete data in archive datasource.");
        }
        IndexExistManager.createMappingIfNotExist(context, datasource, tenantId, accountId, request.getTable(), request.getEntityName(), new Date());
        try {
            return (DeleteByQueryResponse)new DeleteAction(context, datasource, request, tenantId, accountId).execute();
        }
        catch (Exception ex) {
            throw this.wrapperException(ex);
        }
    }

    private LogORMException wrapperException(Throwable throwable) throws LogORMException {
        if (throwable instanceof LogORMException) {
            return (LogORMException)throwable;
        }
        if (throwable instanceof CharacterNotSupportedException) {
            return LogORMExceptionFactory.createWarn(BosRes.get((String)"bos-logormengine", (String)"UnsupportedParam", (String)"\u4e0d\u652f\u6301\u641c\u7d22\u7279\u6b8a\u5b57\u7b26\uff1a{0}\u3002", (Object[])new Object[]{"*"}));
        }
        if (throwable instanceof SqlParseException) {
            return LogORMExceptionFactory.createWarn(BosRes.get((String)"bos-logormengine", (String)"SQLGrammarError", (String)"SQL\u8bed\u6cd5\u9519\u8bef\u3002", (Object[])new Object[0]));
        }
        return LogORMExceptionFactory.createWithContext(throwable.getMessage(), throwable);
    }
}

