/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.BulkResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.RefreshPolicy;
import kd.bos.logorm.codec.CodecFactory;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.LogORMContext;
import kd.bos.logorm.impl.LogORMContextAutoCloseable;
import kd.bos.logorm.request.BatchSaveRequest;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class BatchSaveAction
extends ESAction<BulkResponse> {
    private final BatchSaveRequest request;
    private final RefreshPolicy refreshPolicy;

    public BatchSaveAction(RequestContext context, ESDataSource ds, BatchSaveRequest request, String tenantId, String accountId) {
        super(context, ds, tenantId, accountId);
        this.request = request;
        LogORMContextAutoCloseable closeable = LogORMContextAutoCloseable.get();
        if (closeable != null && closeable.getContext() != null) {
            LogORMContext logORMContext = closeable.getContext();
            this.refreshPolicy = logORMContext.getRefreshPolicy();
        } else {
            this.refreshPolicy = null;
        }
    }

    @Override
    protected HttpRequest build() {
        String endpoint = "_bulk";
        if (this.refreshPolicy != null) {
            endpoint = endpoint + "?refresh=" + this.refreshPolicy.getValue();
        }
        HttpRequest httpRequest = this.createRequest(endpoint, HttpRequest.ContentType.JSON, HttpRequest.RequestType.POST);
        StringBuilder data = new StringBuilder();
        Calendar calendar = Calendar.getInstance(this.context.getTimeZone());
        for (int i = 0; i < this.request.getRows().size(); ++i) {
            String action;
            Object[] row = this.request.getRows().get(i);
            BitSet dirty = this.request.getDirty().get(i);
            HashMap head = new HashMap(8);
            HashMap<String, Object> meta = new HashMap<String, Object>(8);
            if (this.request.getOperator() == BatchSaveRequest.Operator.INSERT) {
                action = "create";
            } else if (this.request.getOperator() == BatchSaveRequest.Operator.UPDATE) {
                action = "update";
            } else if (this.request.getOperator() == BatchSaveRequest.Operator.SAVE) {
                action = "index";
            } else {
                throw LogORMExceptionFactory.create("NotSupportedBatchOperator:%s", new Object[]{this.request.getOperator()});
            }
            head.put(action, meta);
            HashMap<String, Object> body = new HashMap<String, Object>(row.length);
            meta.put("_id", row[this.request.getPrimaryValueIndex()]);
            meta.put("_index", this.getIndexSliceName(this.request.getTable(), this.request.getOptDate().get(i)));
            ESConfig.ESCluster esCluster = this.ds.getEsCluster();
            ESConfig.URL url = esCluster.getUrls().get(0);
            ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
            if (ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6) {
                meta.put("_type", "_doc");
            }
            String[] fields = this.request.getColumns();
            int[] sqlTypes = this.request.getFieldSqlTypes();
            for (int j = 0; j < fields.length; ++j) {
                if (!dirty.get(j)) continue;
                Object v = row[j];
                body.put(fields[j], CodecFactory.getBySQLType(sqlTypes[j]).encode(v, calendar));
            }
            data.append(this.object2Json(head, false)).append('\n');
            if (this.request.getOperator() == BatchSaveRequest.Operator.UPDATE) {
                HashMap<String, HashMap<String, Object>> updateBody = new HashMap<String, HashMap<String, Object>>(8);
                updateBody.put("doc", body);
                body = updateBody;
            }
            data.append(this.object2Json(body, false)).append('\n');
        }
        httpRequest.setData(data.toString());
        return httpRequest;
    }

    @Override
    protected BulkResponse parse(String result) throws JsonProcessingException {
        JsonNode root = OBJECT_MAPPER.readTree(result);
        int took = root.get("took").asInt();
        StringBuilder errorString = new StringBuilder("Batch insert/update has error,the error detail message is :\n");
        int[] intResult = new int[]{};
        long[] ids = new long[]{};
        JsonNode items = root.get("items");
        boolean allFail = true;
        boolean hasFail = false;
        if (items instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)items;
            intResult = new int[arrayNode.size()];
            ids = new long[arrayNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode node = (JsonNode)arrayNode.get(i).iterator().next();
                int status = node.get("status").asInt();
                long id = node.get("_id").asLong();
                if (status == 200 || status == 201) {
                    intResult[i] = 1;
                    ids[i] = id;
                    allFail = false;
                    continue;
                }
                hasFail = true;
                intResult[i] = 0;
                ids[i] = 0L;
                JsonNode error = node.get("error");
                if (error == null) continue;
                String errorMsg = error.get("reason").asText("");
                JsonNode causeBy = error.get("caused_by");
                if (causeBy != null) {
                    errorMsg = errorMsg + ';';
                    errorMsg = errorMsg + causeBy.get("reason").asText("");
                }
                errorString.append("id:").append(id).append(" => ").append(errorMsg).append('\n');
            }
            if (hasFail) {
                log.error(errorString.toString());
            }
            if (allFail) {
                throw LogORMExceptionFactory.createWithContext("Batch insert/update all fail.");
            }
        }
        return new BulkResponse(Collections.emptyList(), intResult, ids);
    }
}

