/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kd.bos.logorm.client.es.ElasticSearchObjectSerializable;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.query.QFilter;

class BoolQuery
implements ElasticSearchObjectSerializable {
    private final List<ElasticSearchObjectSerializable> must = new ArrayList<ElasticSearchObjectSerializable>();
    private final List<ElasticSearchObjectSerializable> should = new ArrayList<ElasticSearchObjectSerializable>();
    private final boolean rootNode;
    private final boolean sortByTimestamp;

    private BoolQuery(boolean rootNode, boolean sortByTimestamp) {
        this.rootNode = rootNode;
        this.sortByTimestamp = sortByTimestamp;
    }

    public static BoolQuery create(QFilter[] qFilters, Calendar calendar, boolean sortByTimestamp) {
        QFilter[] copys = new QFilter[qFilters.length];
        for (int i = 0; i < qFilters.length; ++i) {
            copys[i] = qFilters[i].copy();
        }
        QFilter qFilter = copys[0];
        for (int i = 1; i < copys.length; ++i) {
            qFilter = qFilter.and(copys[i]);
        }
        return BoolQuery.trans0(qFilters, calendar, sortByTimestamp);
    }

    private static BoolQuery trans0(QFilter[] qFilters, Calendar calendar, boolean sortByTimestamp) {
        BoolQuery boolQueryBuilder = new BoolQuery(true, sortByTimestamp);
        for (QFilter qFilter : qFilters) {
            boolQueryBuilder.addMust(BoolQuery.doTrans(qFilter, calendar));
        }
        return boolQueryBuilder;
    }

    private static ElasticSearchObjectSerializable doTrans(QFilter qFilter, Calendar calendar) {
        List nests = qFilter.getNests(false);
        if (nests.isEmpty()) {
            return ElasticSearchObjectSerializable.create(qFilter, calendar);
        }
        BoolQuery boolQueryBuilder = new BoolQuery(false, false);
        if (((QFilter.QFilterNest)nests.get(0)).isAnd()) {
            boolQueryBuilder.addMust(ElasticSearchObjectSerializable.create(qFilter, calendar));
        } else {
            boolQueryBuilder.addOr(ElasticSearchObjectSerializable.create(qFilter, calendar));
        }
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                boolQueryBuilder.addMust(BoolQuery.doTrans(nest.getFilter(), calendar));
                continue;
            }
            boolQueryBuilder.addOr(BoolQuery.doTrans(nest.getFilter(), calendar));
        }
        return boolQueryBuilder;
    }

    public void addMust(ElasticSearchObjectSerializable object) {
        this.must.add(object);
    }

    public void addOr(ElasticSearchObjectSerializable object) {
        this.should.add(object);
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (this.rootNode) {
            jgen.writeObjectFieldStart("query");
        }
        jgen.writeObjectFieldStart("bool");
        if (!this.must.isEmpty()) {
            if (this.must.size() == 1) {
                jgen.writeObjectField("must", (Object)this.must.get(0));
            } else {
                jgen.writeArrayFieldStart("must");
                for (ElasticSearchObjectSerializable object : this.must) {
                    jgen.writeObject((Object)object);
                }
                jgen.writeEndArray();
            }
        }
        if (!this.should.isEmpty()) {
            if (this.should.size() == 1) {
                jgen.writeObjectField("should", (Object)this.should.get(0));
            } else {
                jgen.writeArrayFieldStart("should");
                for (ElasticSearchObjectSerializable object : this.should) {
                    jgen.writeObject((Object)object);
                }
                jgen.writeEndArray();
            }
        }
        jgen.writeEndObject();
        if (this.rootNode) {
            jgen.writeEndObject();
        }
        if (this.rootNode && this.sortByTimestamp) {
            jgen.writeArrayFieldStart("sort");
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(PresetPropertyUtils.getSortColumnName());
            jgen.writeObjectField("order", (Object)"desc");
            jgen.writeEndObject();
            jgen.writeEndObject();
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

