/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.ESQueryCompletionResponse;
import kd.bos.logorm.client.es.ESRowContainer;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class CursorAction
extends ESAction<ESQueryCompletionResponse> {
    private final String cursor;

    public CursorAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String cursor) {
        super(context, ds, tenantId, accountId);
        this.cursor = cursor;
    }

    @Override
    protected HttpRequest build() {
        String uri = "";
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        uri = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6 ? uri + "/_xpack/sql?format=json" : uri + "/_sql?format=json";
        HttpRequest request = this.createRequest(uri, HttpRequest.ContentType.JSON, HttpRequest.RequestType.POST);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cursor", this.cursor);
        request.setData(this.object2Json(data));
        return request;
    }

    @Override
    public ESQueryCompletionResponse parse(String result) throws JsonProcessingException {
        JsonNode root = OBJECT_MAPPER.readTree(result);
        JsonNode nextCursor = root.get("cursor");
        String cursorKey = nextCursor == null ? null : nextCursor.asText();
        ESRowContainer rowContainer = new ESRowContainer(this.context, this.ds, null, this.tenantId, this.accountId, cursorKey, root.get("rows").iterator());
        return new ESQueryCompletionResponse(rowContainer, null);
    }
}

