/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.client.CompletionResponse;
import kd.bos.logorm.client.es.IndexSliceStrategy;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.ObjectMapperUtils;

public abstract class ESAction<T extends CompletionResponse> {
    protected static final Log log = LogFactory.getLog((String)"LogORM");
    protected static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtils.getMapper(false);
    protected final RequestContext context;
    protected final String tenantId;
    protected final String accountId;
    protected String schema;
    protected ESDataSource ds;
    protected int esVersion;

    protected ESAction(RequestContext context, ESDataSource ds, String tenantId, String accountId) {
        this.context = context;
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.ds = ds;
        this.schema = this.ds.getSchema();
        this.initESVersion();
    }

    protected final HttpRequest createRequest(String endpoint, HttpRequest.ContentType contentType, HttpRequest.RequestType requestType) {
        HttpRequest request = new HttpRequest();
        if (contentType != null) {
            request.setContentType(contentType);
        }
        request.setRequestType(requestType);
        request.setEndpoint(endpoint);
        request.setClient(this.ds.getClient());
        return request;
    }

    /*
     * Exception decompiling
     */
    public final T execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String object2Json(Object object) {
        return this.object2Json(object, true);
    }

    protected String object2Json(Object object, boolean indent) {
        try {
            return ObjectMapperUtils.getMapper(indent).writeValueAsString(object);
        }
        catch (IOException e) {
            throw LogORMExceptionFactory.create("Serialize param to json fail," + e.getMessage(), e);
        }
    }

    protected String getIndexAllName(String table, Date date) {
        IndexSliceStrategy indexSliceStrategy = IndexSliceStrategy.of(this.context.getSliceStrategy());
        return indexSliceStrategy.getIndexAllName(this.schema, table, date);
    }

    protected String getIndexSliceName(String table, Date date) {
        IndexSliceStrategy indexSliceStrategy = IndexSliceStrategy.of(this.context.getSliceStrategy());
        return indexSliceStrategy.getIndexSliceName(this.schema, table, date);
    }

    protected String getIndexAllName(String table, Date date, DateInterval interval) {
        IndexSliceStrategy indexSliceStrategy = IndexSliceStrategy.of(this.context.getSliceStrategy());
        return indexSliceStrategy.getIndexAllName(this.schema, table, date, interval);
    }

    protected abstract HttpRequest build();

    protected abstract T parse(String var1) throws JsonProcessingException;

    private void initESVersion() {
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        this.esVersion = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig);
    }
}

