/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.client.es.AddNotExistFieldAction;
import kd.bos.logorm.client.es.FlushIndexAction;
import kd.bos.logorm.client.es.GetIndexFieldAction;
import kd.bos.logorm.client.es.GetIndexFieldResponse;
import kd.bos.logorm.client.es.MappingPropertiesObject;
import kd.bos.logorm.client.es.PresetFieldManager;
import kd.bos.logorm.codec.DataType;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.datasource.es.RestClientFactory;
import kd.bos.logorm.exception.es.IndexNotFoundException;
import kd.bos.logorm.exception.es.TypeMissingException;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.logorm.request.RequestContext;

public class ElasticFieldUpdateManager {
    private static final Log log = LogFactory.getLog((String)"LogORM");

    public static void updateField(String entityName, RequestContext context, String tenantId, String accountId, EntityMetadataContext entityMetadataContext) {
        GetIndexFieldResponse response;
        if ("t_isv_1".equalsIgnoreCase(entityMetadataContext.getTableName())) {
            log.warn("Update elastic field fail,the table name is default value:t_isv_1 .");
            return;
        }
        ESDataSource dataSource = RestClientFactory.getClient(tenantId, accountId);
        GetIndexFieldAction getIndexFieldAction = new GetIndexFieldAction(entityMetadataContext.getTableName(), context, dataSource, tenantId, accountId);
        try {
            response = (GetIndexFieldResponse)getIndexFieldAction.execute();
        }
        catch (Exception ex) {
            if (ex instanceof IndexNotFoundException || ex instanceof TypeMissingException) {
                return;
            }
            throw ex;
        }
        if (response.getFields().isEmpty()) {
            log.warn("Index:%s has return empty field.", (Object)response.getIndex());
            return;
        }
        List<GetIndexFieldResponse.Field> fields = response.getFields();
        HashSet<String> elasticFieldNameSet = new HashSet<String>(fields.size());
        ArrayList<EntityProperty> needAddField = new ArrayList<EntityProperty>(fields.size());
        for (GetIndexFieldResponse.Field field : fields) {
            elasticFieldNameSet.add(field.getName().toLowerCase());
        }
        for (String columnName : entityMetadataContext.getColumnNames()) {
            if (elasticFieldNameSet.contains(columnName.toLowerCase())) continue;
            needAddField.add(entityMetadataContext.getColumnProperty(columnName));
        }
        if (needAddField.isEmpty()) {
            return;
        }
        String[] needAddColumnNames = new String[needAddField.size()];
        DataType[] needAddDataTypes = new DataType[needAddField.size()];
        for (int i = 0; i < needAddField.size(); ++i) {
            EntityProperty property = (EntityProperty)needAddField.get(i);
            needAddColumnNames[i] = property.getColumnName();
            needAddDataTypes[i] = DataType.getByJdbcType(property.getSqlType());
        }
        MappingPropertiesObject mappingPropertiesObject = PresetFieldManager.genMappingPropertiesObject(needAddColumnNames, needAddDataTypes, true);
        AddNotExistFieldAction addNotExistFieldAction = new AddNotExistFieldAction(context, dataSource, tenantId, accountId, entityMetadataContext.getTableName(), mappingPropertiesObject);
        addNotExistFieldAction.execute();
        FlushIndexAction flushIndexAction = new FlushIndexAction(context, dataSource, tenantId, accountId, entityName, new Date(), true);
        flushIndexAction.execute();
    }
}

