/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Calendar;
import kd.bos.logorm.client.es.ExistsObject;
import kd.bos.logorm.client.es.MissingObject;
import kd.bos.logorm.client.es.RangeObject;
import kd.bos.logorm.client.es.TermObject;
import kd.bos.logorm.client.es.WildcardObject;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.orm.query.QFilter;

public interface ElasticSearchObjectSerializable {
    public void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    public static ElasticSearchObjectSerializable create(QFilter qFilter, Calendar calendar) {
        try {
            return ElasticSearchObjectSerializable.create(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue(), calendar);
        }
        catch (Exception e) {
            throw LogORMExceptionFactory.createWithContext(e, "Unsupported qFilter: %s .", qFilter);
        }
    }

    public static ElasticSearchObjectSerializable create(String property, String qcp, Object value, Calendar calendar) {
        switch (qcp) {
            case "=": 
            case "in": {
                return new TermObject(property, qcp, value, calendar);
            }
            case "not in": {
                return new MissingObject(ElasticSearchObjectSerializable.create(property, "in", value, calendar));
            }
            case "like": {
                return new WildcardObject(property, value);
            }
            case "not like": {
                return new MissingObject(ElasticSearchObjectSerializable.create(property, "like", value, calendar));
            }
            case "<=": 
            case "<": 
            case ">=": 
            case ">": {
                return new RangeObject(property, qcp, value, calendar);
            }
            case "!=": 
            case "<>": {
                return new MissingObject(ElasticSearchObjectSerializable.create(property, "=", value, calendar));
            }
            case "is not null": {
                return new ExistsObject(property);
            }
            case "is null": {
                return new MissingObject(ElasticSearchObjectSerializable.create(property, "is not null", value, calendar));
            }
        }
        throw LogORMExceptionFactory.createWithContext("Unsupported qcp: %s .", qcp);
    }
}

