/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.Iterator;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.GetIndexFieldResponse;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.exception.es.IndexNotFoundException;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.ObjectMapperUtils;

public class GetIndexFieldAction
extends ESAction<GetIndexFieldResponse> {
    private final String index;

    protected GetIndexFieldAction(String index, RequestContext context, ESDataSource ds, String tenantId, String accountId) {
        super(context, ds, tenantId, accountId);
        this.index = index;
    }

    @Override
    protected HttpRequest build() {
        String idx = this.getIndexAllName(this.index, new Date());
        String uri = "/%s";
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        uri = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6 ? uri + "/_doc/_mapping?include_type_name&pretty=true" : uri + "/_mapping?pretty=true";
        return this.createRequest(String.format(uri, idx), null, HttpRequest.RequestType.GET);
    }

    @Override
    protected GetIndexFieldResponse parse(String result) throws JsonProcessingException {
        ObjectNode root = (ObjectNode)ObjectMapperUtils.getMapper(false).readTree(result);
        Iterator indexIterator = root.fieldNames();
        if (!indexIterator.hasNext()) {
            ESConfig.ESCluster esCluster = this.ds.getEsCluster();
            ESConfig.URL url = esCluster.getUrls().get(0);
            ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
            if (ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6) {
                throw LogORMExceptionFactory.createWithContext("Get index:%s field but not return %s.", this.getIndexAllName(this.index, new Date()), result);
            }
            throw new IndexNotFoundException("no index[" + this.index + "] found");
        }
        String indexName = (String)indexIterator.next();
        GetIndexFieldResponse response = new GetIndexFieldResponse(indexName);
        root = (ObjectNode)root.get(indexName).get("mappings");
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        root = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6 ? (ObjectNode)root.get("_doc").get("properties") : (ObjectNode)root.get("properties");
        Iterator fieldNameIterator = root.fieldNames();
        while (fieldNameIterator.hasNext()) {
            String fieldName = (String)fieldNameIterator.next();
            JsonNode type = root.get(fieldName);
            response.add(type.get("type").asText(), fieldName);
        }
        return response;
    }

    public String getAllIndex() {
        return this.getIndexAllName(this.index, new Date());
    }
}

