/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.CompletionResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class IndexExistAction
extends ESAction<CompletionResponse> {
    private final String sliceTableName;

    public IndexExistAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String tableName, Date date) {
        super(context, ds, tenantId, accountId);
        this.sliceTableName = this.getIndexSliceName(tableName, date);
    }

    @Override
    protected HttpRequest build() {
        HttpRequest.RequestType requestType;
        String uri = '/' + this.sliceTableName + "/_mapping";
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        if (ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6) {
            uri = uri + "/_doc";
            requestType = HttpRequest.RequestType.HEAD;
        } else {
            requestType = HttpRequest.RequestType.GET;
        }
        return this.createRequest(uri, null, requestType);
    }

    @Override
    protected CompletionResponse parse(String result) throws JsonProcessingException {
        return new CompletionResponse(){};
    }

    public String getSliceTableName() {
        return this.sliceTableName;
    }
}

