/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.ConditionSqlBuilder;
import kd.bos.logorm.client.QueryCompletionResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.ESRowContainer;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.client.es.optimization.Optimization;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.codec.CodecFactory;
import kd.bos.logorm.codec.DataType;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.QueryRequest;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.orm.query.QFilter;

public class QueryAction
extends ESAction<QueryCompletionResponse> {
    private final QueryRequest request;

    public QueryAction(RequestContext context, ESDataSource ds, QueryRequest request, String tenantId, String accountId) {
        super(context, ds, tenantId, accountId);
        this.request = request;
    }

    @Override
    protected HttpRequest build() {
        String uri = "";
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        uri = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6 ? uri + "/_xpack/sql?format=json" : uri + "/_sql?format=json";
        HttpRequest httpRequest = this.createRequest(uri, HttpRequest.ContentType.JSON, HttpRequest.RequestType.POST);
        StringBuilder builder = new StringBuilder();
        DateInterval dateInterval = Optimization.analysisFilterDateInterval(this.request.getWhere(), this.request.getOptDatePropertyName());
        String tableName = dateInterval == null ? this.getIndexAllName(this.request.getTable(), new Date()) : this.getIndexAllName(this.request.getTable(), new Date(), dateInterval);
        builder.append("SELECT ");
        ArrayList<String> queryField = new ArrayList<String>(this.request.getSelect().length);
        for (QueryRequest.SelectItem selectItem : this.request.getSelect()) {
            String columnName = selectItem.getColumnName();
            queryField.add(columnName);
        }
        builder.append(String.join((CharSequence)",", queryField)).append(" FROM ");
        builder.append('\"').append(tableName).append('\"');
        QFilter[] where = this.request.getWhere();
        if (where != null && where.length > 0) {
            builder.append(" WHERE ");
            ArrayList<String> conditions = new ArrayList<String>(where.length);
            Calendar calendar = Calendar.getInstance(this.context.getTimeZone());
            QFilter[] qFilterArray = where;
            int n = qFilterArray.length;
            for (int i = 0; i < n; ++i) {
                QFilter qFilter = qFilterArray[i];
                conditions.add(String.format("(%s)", new ConditionSqlBuilder(qFilter, false, calendar).getSql()));
            }
            builder.append(String.join((CharSequence)" AND ", conditions));
        }
        if (this.request.getOrderBy() != null && this.request.getOrderBy().length > 0) {
            QueryRequest.OrderByItem[] orderByItems = this.request.getOrderBy();
            ArrayList<String> orderBys = new ArrayList<String>(orderByItems.length);
            for (QueryRequest.OrderByItem orderByItem : orderByItems) {
                orderBys.add(orderByItem.getColumnName() + " " + orderByItem.getOrdering().toUpperCase());
            }
            builder.append(" ORDER BY ").append(String.join((CharSequence)",", orderBys));
        }
        if (this.request.getLimit() != null) {
            int limit = this.request.getLimit();
            if (this.request.getOffset() != null) {
                limit += this.request.getOffset().intValue();
            }
            builder.append(" LIMIT ").append(limit);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("query", builder.toString());
        data.put("fetch_size", this.context.getFetchSize());
        httpRequest.setData(this.object2Json(data));
        return httpRequest;
    }

    @Override
    protected QueryCompletionResponse parse(String result) throws JsonProcessingException {
        JsonNode root = OBJECT_MAPPER.readTree(result);
        ArrayNode metaArrayNode = (ArrayNode)root.get("columns");
        RowMeta meta = this.initRowMeta(this.request, metaArrayNode);
        Codec<?>[] codecs = this.initCodec(metaArrayNode);
        JsonNode cursor = root.get("cursor");
        String cursorKey = cursor == null ? null : cursor.asText();
        ESRowContainer rowContainer = new ESRowContainer(this.context, this.ds, codecs, this.tenantId, this.accountId, cursorKey, root.get("rows").iterator());
        DataSet ds = Algo.create((String)"LogORM").createDataSet((Iterator)rowContainer, meta);
        if (this.request.getOffset() != null && this.request.getLimit() != null) {
            ds = ds.range(this.request.getOffset().intValue(), this.request.getLimit().intValue());
        }
        return new QueryCompletionResponse(ds);
    }

    private RowMeta initRowMeta(QueryRequest action, ArrayNode metaArrayNode) {
        kd.bos.algo.DataType[] dts = new kd.bos.algo.DataType[metaArrayNode.size()];
        for (int i = 0; i < metaArrayNode.size(); ++i) {
            dts[i] = DataType.parseDataType(metaArrayNode.get(i).get("type").asText()).getAlgoDataType();
        }
        String[] fields = new String[dts.length];
        QueryRequest.SelectItem[] select = action.getSelect();
        for (int i = 0; i < select.length; ++i) {
            fields[i] = select[i].getPropertyName();
        }
        return new RowMeta(fields, dts);
    }

    private Codec<?>[] initCodec(ArrayNode metaArrayNode) {
        Codec[] codecs = new Codec[metaArrayNode.size()];
        for (int i = 0; i < metaArrayNode.size(); ++i) {
            codecs[i] = CodecFactory.getByDataType(metaArrayNode.get(i).get("type").asText());
        }
        return codecs;
    }
}

