/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import kd.bos.logorm.client.es.ElasticSearchObjectSerializable;
import kd.bos.logorm.codec.CodecFactory;
import kd.bos.logorm.exception.LogORMException;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.utils.EachUtils;
import kd.bos.logorm.utils.ObjectTypeUtils;

class TermObject
implements ElasticSearchObjectSerializable {
    private String key;
    private Object value;
    private boolean isInQuery;
    private Calendar calendar;

    public TermObject(String key, String qcp, Object value, Calendar calendar) {
        this.key = key;
        this.value = value;
        switch (qcp) {
            case "=": {
                this.isInQuery = false;
                break;
            }
            case "in": {
                this.isInQuery = true;
                break;
            }
            default: {
                throw LogORMExceptionFactory.createWithContext("Unsupported qcp: %s for TermObject.", qcp);
            }
        }
        this.calendar = calendar;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (this.isInQuery) {
            jgen.writeFieldName("terms");
        } else {
            jgen.writeFieldName("term");
        }
        jgen.writeStartObject();
        if (this.isInQuery) {
            jgen.writeFieldName(this.key);
            jgen.writeStartArray();
            List<Object> array = EachUtils.eachArrayOrCollection(this.value, o -> CodecFactory.get(o).encode(o, this.calendar));
            for (Object o2 : array) {
                jgen.writeObject(o2);
            }
            jgen.writeEndArray();
        } else {
            try {
                jgen.writeObjectField(this.key, CodecFactory.get(this.value).encode(this.value, this.calendar));
            }
            catch (Exception ex) {
                if (ex instanceof LogORMException) {
                    throw LogORMExceptionFactory.createWithContext(ex, "QFilter not supported value type, the cp is = but value type is %s.", ObjectTypeUtils.getTypeName(this.value));
                }
                throw ex;
            }
        }
        jgen.writeEndObject();
        jgen.writeEndObject();
    }
}

