/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.ConditionSqlBuilder;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.TranslateObject;
import kd.bos.logorm.client.es.TranslateResponse;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.ObjectMapperUtils;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.query.QFilter;

public class TranslateAction
extends ESAction<TranslateResponse> {
    private final String table;
    private final QFilter[] where;

    public TranslateAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String table, QFilter[] where) {
        super(context, ds, tenantId, accountId);
        this.table = table;
        this.where = where;
    }

    @Override
    protected HttpRequest build() {
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        String uri = ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6 ? "/_xpack/sql/translate" : "/_sql/translate";
        HttpRequest httpRequest = this.createRequest(uri, HttpRequest.ContentType.JSON, HttpRequest.RequestType.POST);
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(PresetPropertyUtils.getSortColumnName()).append(" FROM ").append('\"').append(this.getIndexAllName(this.table, new Date())).append('\"').append(" WHERE ");
        ArrayList<String> conditions = new ArrayList<String>(10);
        for (QFilter qFilter : this.where) {
            ConditionSqlBuilder conditionSqlBuilder = new ConditionSqlBuilder(qFilter, false, Calendar.getInstance(this.context.getTimeZone()));
            conditions.add(conditionSqlBuilder.getSql());
        }
        sqlBuilder.append(String.join((CharSequence)" AND ", conditions));
        sqlBuilder.append(" LIMIT 1");
        TranslateObject translateObject = new TranslateObject(sqlBuilder.toString());
        httpRequest.setData(this.object2Json(translateObject));
        return httpRequest;
    }

    @Override
    protected TranslateResponse parse(String result) throws JsonProcessingException {
        ObjectNode root = (ObjectNode)ObjectMapperUtils.getMapper(false).readTree(result);
        return new TranslateResponse(root.get("query"));
    }
}

