/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import kd.bos.logorm.client.es.ElasticSearchObjectSerializable;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.utils.ObjectTypeUtils;

class WildcardObject
implements ElasticSearchObjectSerializable {
    private final String key;
    private final String value;

    public WildcardObject(String key, Object value) {
        this.key = key;
        if (!(value instanceof String)) {
            throw LogORMExceptionFactory.createWithContext("Like query's value must be string, param value type: %s .", ObjectTypeUtils.getTypeName(value));
        }
        String param = (String)value;
        StringBuilder result = new StringBuilder(param);
        for (int i = 0; i < result.length(); ++i) {
            char ch = result.charAt(i);
            if (ch == '%' || ch == '_') {
                if (i - 1 >= 0 && result.charAt(i - 1) != '\\') {
                    result.setCharAt(i, ch == '%' ? (char)'*' : '?');
                    continue;
                }
                if (i - 2 >= 0 && result.charAt(i - 2) == '\\' && result.charAt(i - 1) == '\\') {
                    result.setCharAt(i, ch == '%' ? (char)'*' : '?');
                    continue;
                }
                if (i - 1 >= 0 && result.charAt(i - 1) == '\\') {
                    result.deleteCharAt(i - 1);
                    continue;
                }
                result.setCharAt(i, ch == '%' ? (char)'*' : '?');
                continue;
            }
            if (ch != '*' && ch != '?') continue;
            result.insert(i, '\\');
            ++i;
        }
        this.value = result.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName("wildcard");
        jgen.writeStartObject();
        jgen.writeObjectField(this.key, (Object)this.value);
        jgen.writeEndObject();
        jgen.writeEndObject();
    }
}

