/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es.optimization;

import java.time.LocalDate;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.client.es.optimization.PointDateInterval;
import kd.bos.logorm.client.es.optimization.RangeDateInterval;
import kd.bos.logorm.client.es.optimization.UnlimitedDateInterval;
import kd.bos.util.Pair;

public class DirectionDateInterval
implements DateInterval {
    private LocalDate date;
    private Direction direction;

    public DirectionDateInterval(LocalDate date, Direction direction) {
        this.date = date;
        this.direction = direction;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public DateInterval and(DateInterval target) {
        if (target instanceof DirectionDateInterval) {
            if (this.direction != ((DirectionDateInterval)target).direction) {
                LocalDate start;
                LocalDate end;
                if (this.direction == Direction.LEFT) {
                    end = this.date;
                    start = ((DirectionDateInterval)target).date;
                } else {
                    end = ((DirectionDateInterval)target).date;
                    start = this.date;
                }
                int compare = start.compareTo(end);
                if (compare == 0) {
                    return new PointDateInterval(start);
                }
                if (compare < 0) {
                    return new RangeDateInterval(start, end);
                }
                return UnlimitedDateInterval.UNLIMITED;
            }
            if (this.direction == Direction.LEFT) {
                this.date = this.date.compareTo(((DirectionDateInterval)target).date) < 0 ? this.date : ((DirectionDateInterval)target).date;
                return this;
            }
            this.date = this.date.compareTo(((DirectionDateInterval)target).date) > 0 ? this.date : ((DirectionDateInterval)target).date;
            return this;
        }
        return target.and(this);
    }

    @Override
    public DateInterval or(DateInterval target) {
        if (target instanceof PointDateInterval) {
            PointDateInterval point = (PointDateInterval)target;
            if (this.direction == Direction.LEFT && point.getDate().compareTo(this.date) > 0) {
                this.date = point.getDate();
            } else if (this.direction == Direction.RIGHT && point.getDate().compareTo(this.date) < 0) {
                this.date = point.getDate();
            }
            return this;
        }
        if (target instanceof DirectionDateInterval) {
            DirectionDateInterval directionDateInterval = (DirectionDateInterval)target;
            if (this.direction != directionDateInterval.direction) {
                return UnlimitedDateInterval.UNLIMITED;
            }
            this.date = this.date.compareTo(directionDateInterval.date) < 0 ? this.date : directionDateInterval.date;
            return this;
        }
        return target.or(this);
    }

    @Override
    public Pair<LocalDate, LocalDate> getDateRange() {
        if (this.direction == Direction.LEFT) {
            return new Pair(null, (Object)this.date);
        }
        return new Pair((Object)this.date, null);
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

