/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es.optimization;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.client.es.optimization.DirectionDateInterval;
import kd.bos.logorm.client.es.optimization.PointDateInterval;
import kd.bos.logorm.client.es.optimization.UnlimitedDateInterval;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.orm.query.QFilter;

public final class Optimization {
    private static final Log logger = LogFactory.getLog(Optimization.class);

    public static DateInterval analysisFilterDateInterval(QFilter[] filters, String propertyName) {
        if (!LogORMConfig.isEnableOptimization()) {
            return null;
        }
        try {
            return Optimization.doAnalysisFilterDateInterval(filters, propertyName);
        }
        catch (Throwable exception) {
            logger.error("LogORM optimization cause error" + exception.getMessage(), exception);
            return null;
        }
    }

    private static DateInterval doAnalysisFilterDateInterval(QFilter[] filters, String propertyName) {
        if (filters == null || filters.length == 0) {
            return UnlimitedDateInterval.UNLIMITED;
        }
        DateInterval dateInterval = Optimization.doAnalysisFilterDateInterval(filters[0], propertyName);
        for (int i = 1; i < filters.length; ++i) {
            dateInterval = dateInterval.and(Optimization.doAnalysisFilterDateInterval(filters[i], propertyName));
        }
        return dateInterval;
    }

    private static DateInterval doAnalysisFilterDateInterval(QFilter filter, String propertyName) {
        if (filter == null) {
            return UnlimitedDateInterval.UNLIMITED;
        }
        QFilter[] recombine = filter.recombine();
        ArrayList<UnlimitedDateInterval> intervals = new ArrayList<UnlimitedDateInterval>(recombine.length);
        for (QFilter qFilter : recombine) {
            List nests = qFilter.getNests(false);
            DateInterval interval = null;
            if (!qFilter.getProperty().trim().equalsIgnoreCase(propertyName)) {
                interval = UnlimitedDateInterval.UNLIMITED;
            } else {
                String cp = qFilter.getCP();
                LocalDateTime dateTime = Optimization.transToLocalDate(qFilter.getValue());
                if (dateTime == null) {
                    interval = UnlimitedDateInterval.UNLIMITED;
                    intervals.add((UnlimitedDateInterval)interval);
                    continue;
                }
                switch (cp) {
                    case "=": {
                        interval = new PointDateInterval(dateTime.toLocalDate());
                        break;
                    }
                    case ">": 
                    case ">=": {
                        interval = new DirectionDateInterval(dateTime.toLocalDate(), DirectionDateInterval.Direction.RIGHT);
                        break;
                    }
                    case "<": {
                        LocalDateTime startOfDay = dateTime.toLocalDate().atStartOfDay();
                        LocalDate date = dateTime.toLocalDate();
                        if (dateTime.compareTo(startOfDay) == 0) {
                            date = dateTime.plusDays(-1L).toLocalDate();
                        }
                        interval = new DirectionDateInterval(date, DirectionDateInterval.Direction.LEFT);
                        break;
                    }
                    case "<=": {
                        interval = new DirectionDateInterval(dateTime.toLocalDate(), DirectionDateInterval.Direction.LEFT);
                        break;
                    }
                    default: {
                        interval = UnlimitedDateInterval.UNLIMITED;
                    }
                }
            }
            if (!nests.isEmpty()) {
                for (QFilter.QFilterNest nest : nests) {
                    DateInterval nestInterval = Optimization.doAnalysisFilterDateInterval(nest.getFilter(), propertyName);
                    if (nest.isAnd()) {
                        interval = interval.and(nestInterval);
                        continue;
                    }
                    interval = interval.or(nestInterval);
                }
            }
            intervals.add((UnlimitedDateInterval)interval);
        }
        if (intervals.isEmpty()) {
            return UnlimitedDateInterval.UNLIMITED;
        }
        DateInterval first = (DateInterval)intervals.get(0);
        for (int i = 1; i < intervals.size(); ++i) {
            first = first.and((DateInterval)intervals.get(i));
        }
        return first;
    }

    private static LocalDateTime transToLocalDate(Object object) {
        LocalDateTime result = null;
        if (object instanceof java.sql.Date) {
            result = ((java.sql.Date)object).toLocalDate().atStartOfDay();
        }
        if (object instanceof Date) {
            result = ((Date)object).toInstant().atZone(LogORMConfig.getTimeZoneId()).toLocalDateTime();
        }
        if (object instanceof LocalDateTime) {
            result = (LocalDateTime)object;
        }
        if (object instanceof LocalDate) {
            result = ((LocalDate)object).atStartOfDay();
        }
        return result;
    }
}

