/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import kd.bos.logorm.exception.LogORMExceptionFactory;

public enum DataType {
    TEXT("text", 12, (kd.bos.algo.DataType)kd.bos.algo.DataType.StringType),
    KEYWORD("keyword", 12, (kd.bos.algo.DataType)kd.bos.algo.DataType.StringType),
    LONG("long", -5, (kd.bos.algo.DataType)kd.bos.algo.DataType.LongType),
    DATE("date", 93, (kd.bos.algo.DataType)kd.bos.algo.DataType.DateType),
    INTEGER("integer", 4, (kd.bos.algo.DataType)kd.bos.algo.DataType.IntegerType),
    DOUBLE("double", 8, (kd.bos.algo.DataType)kd.bos.algo.DataType.DoubleType),
    NULL("null", 0, (kd.bos.algo.DataType)kd.bos.algo.DataType.NullType);

    private final String esType;
    private final int jdbcType;
    private final kd.bos.algo.DataType algoDataType;

    private DataType(String esType, int jdbcType, kd.bos.algo.DataType algoDataType) {
        this.esType = esType;
        this.jdbcType = jdbcType;
        this.algoDataType = algoDataType;
    }

    public static DataType getByJdbcType(int type) {
        switch (type) {
            case -9: 
            case 12: {
                return KEYWORD;
            }
            case 2005: 
            case 2011: {
                return TEXT;
            }
            case -5: {
                return LONG;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE;
            }
            case -6: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case 3: {
                return DOUBLE;
            }
            case 0: {
                return NULL;
            }
        }
        throw LogORMExceptionFactory.create("Unsupported jdbc type: " + type + '.');
    }

    public static DataType parseDataType(String type) {
        switch (type) {
            case "text": {
                return TEXT;
            }
            case "keyword": {
                return KEYWORD;
            }
            case "long": {
                return LONG;
            }
            case "integer": {
                return INTEGER;
            }
            case "datetime": 
            case "date": {
                return DATE;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
        }
        throw LogORMExceptionFactory.create("Unsupported data type: " + type + '.');
    }

    public String getEsType() {
        return this.esType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public kd.bos.algo.DataType getAlgoDataType() {
        return this.algoDataType;
    }
}

