/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class DateCodec
implements Codec<Object> {
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})\\.(\\d{3})Z");
    private static final Pattern NUMBER_CHECK_PATTERN = Pattern.compile("^\\d+$");

    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Timestamp) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return '\'' + format.format((Timestamp)value) + '\'';
        }
        if (value instanceof java.sql.Date) {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return '\'' + format.format((java.sql.Date)value) + '\'';
        }
        if (value instanceof Time) {
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return '\'' + format.format((Time)value) + '\'';
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return '\'' + format.format((Date)value) + '\'';
        }
        if (value instanceof LocalDateTime) {
            DateTimeFormatter formatter = TIMESTAMP_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return '\'' + ((LocalDateTime)value).format(formatter) + '\'';
        }
        if (value instanceof LocalTime) {
            DateTimeFormatter formatter = TIME_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return '\'' + ((LocalTime)value).format(formatter) + '\'';
        }
        if (value instanceof LocalDate) {
            DateTimeFormatter formatter = DATE_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return '\'' + ((LocalDate)value).format(formatter) + '\'';
        }
        if (value instanceof Integer) {
            Timestamp timestamp = new Timestamp((Integer)value * 1000);
            return this.encodeAsText(timestamp, cal);
        }
        if (value instanceof Long) {
            Timestamp timestamp = new Timestamp((Long)value);
            return this.encodeAsText(timestamp, cal);
        }
        throw LogORMExceptionFactory.create("Encode date value as text fail,unsupported value type:" + value.getClass().getName());
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return format.format((Timestamp)value);
        }
        if (value instanceof java.sql.Date) {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return format.format((java.sql.Date)value);
        }
        if (value instanceof Time) {
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return format.format((Time)value);
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            format.setTimeZone(cal.getTimeZone());
            return format.format((Date)value);
        }
        if (value instanceof LocalDateTime) {
            DateTimeFormatter formatter = TIMESTAMP_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return ((LocalDateTime)value).format(formatter);
        }
        if (value instanceof LocalTime) {
            DateTimeFormatter formatter = TIME_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return ((LocalTime)value).format(formatter);
        }
        if (value instanceof LocalDate) {
            DateTimeFormatter formatter = DATE_FORMATTER.withZone(ZoneId.of(cal.getTimeZone().getID()));
            return ((LocalDate)value).format(formatter);
        }
        if (value instanceof Integer) {
            Timestamp timestamp = new Timestamp((Integer)value * 1000);
            return this.encodeAsText(timestamp, cal);
        }
        if (value instanceof Long) {
            Timestamp timestamp = new Timestamp((Long)value);
            return this.encodeAsText(timestamp, cal);
        }
        throw LogORMExceptionFactory.create("Encode date value fail,unsupported value type:" + value.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        String value = src.asText();
        if (NUMBER_CHECK_PATTERN.matcher(value).find()) {
            long millis = Long.parseLong(value);
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.clear();
                cal.setTimeInMillis(millis);
                return new Timestamp(cal.getTimeInMillis());
            }
        }
        if (value.length() > 10) {
            Matcher matcher = TIMESTAMP_PATTERN.matcher(value);
            if (!matcher.find()) {
                throw LogORMExceptionFactory.create(String.format("Data %s cannot be decoded as java.sql.Timestamp", value));
            }
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.clear();
                cal.set(1, Integer.parseInt(matcher.group(1)));
                cal.set(2, Integer.parseInt(matcher.group(2)) - 1);
                cal.set(5, Integer.parseInt(matcher.group(3)));
                cal.set(11, Integer.parseInt(matcher.group(4)));
                cal.set(12, Integer.parseInt(matcher.group(5)));
                cal.set(13, Integer.parseInt(matcher.group(6)));
                cal.set(14, Integer.parseInt(matcher.group(7)));
                return new Timestamp(cal.getTimeInMillis());
            }
        }
        if (value.length() == 10) {
            String[] part = value.split("-");
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.clear();
                cal.set(1, Integer.parseInt(part[0]));
                cal.set(2, Integer.parseInt(part[1]) - 1);
                cal.set(5, Integer.parseInt(part[2]));
                return new java.sql.Date(cal.getTimeInMillis());
            }
        }
        if (value.length() == 8) {
            String[] part = value.split(":");
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.clear();
                cal.set(11, Integer.parseInt(part[0]));
                cal.set(12, Integer.parseInt(part[1]));
                cal.set(13, Integer.parseInt(part[2]));
                return new java.sql.Date(cal.getTimeInMillis());
            }
        }
        throw LogORMExceptionFactory.create(String.format("Data %s cannot be decoded as java.sql.Timestamp", value));
    }
}

