/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Calendar;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class FloatCodec
implements Codec<Float> {
    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        throw LogORMExceptionFactory.create("Encode float value as text fail,unsupported value type:" + value.getClass().getName());
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            catch (Exception ex) {
                throw LogORMExceptionFactory.create("Unknown value for FloatCodec:" + value, ex);
            }
        }
        if (value == null) {
            return null;
        }
        throw LogORMExceptionFactory.create("Unknown value for FloatCodec:" + value);
    }

    @Override
    public Float decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(src.asText()));
    }
}

