/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Calendar;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class LongCodec
implements Codec<Long> {
    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        throw LogORMExceptionFactory.create("Encode long value as text fail,unsupported value type:" + value.getClass().getName());
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (Exception ex) {
                throw LogORMExceptionFactory.create("Unknown value for LongCodec:" + value, ex);
            }
        }
        if (value == null) {
            return null;
        }
        throw LogORMExceptionFactory.create("Unknown value for LongCodec:" + value);
    }

    @Override
    public Long decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        return src.asLong();
    }
}

