/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.config;

import java.time.ZoneId;
import kd.bos.util.ConfigurationUtil;

public class LogORMConfig {
    private static String timeZone = "Asia/Shanghai";
    private static ZoneId timeZoneId = ZoneId.of(timeZone);
    private static int fetchSize = 10000;
    private static int maxPerRouteConn = 10;
    private static int maxTotalConn = 100;
    private static int socketTimeout = 5000;
    private static int queryTimeout = 300000;
    private static int connectionTimeout = 60000;
    private static int maxLikeValueLength = 500;
    private static int shardsNumber = 5;
    private static int replicasNumber = 1;
    private static int batchSplitCount = 10000;
    private static boolean logElasticRequest = true;
    private static boolean logElasticRequestRequestBody = false;
    private static boolean logElasticRequestResponseBody = false;
    private static boolean logElasticRequestHost = false;
    private static boolean useServerTranslateFilter = true;
    private static boolean traceSlowQueryStack = false;
    private static boolean enableOptimization = true;
    private static boolean optimizationSetNowAsEnd = true;

    private LogORMConfig() {
    }

    public static String getTimeZone() {
        return timeZone;
    }

    public static int getFetchSize() {
        return fetchSize;
    }

    public static int getQueryTimeout() {
        return queryTimeout;
    }

    public static boolean isLogElasticRequest() {
        return logElasticRequest;
    }

    public static boolean isLogElasticRequestRequestBody() {
        return logElasticRequestRequestBody;
    }

    public static boolean isLogElasticRequestResponseBody() {
        return logElasticRequestResponseBody;
    }

    public static boolean isLogElasticRequestHost() {
        return logElasticRequestHost;
    }

    public static int getMaxPerRouteConn() {
        return maxPerRouteConn;
    }

    public static int getMaxTotalConn() {
        return maxTotalConn;
    }

    public static int getSocketTimeout() {
        return socketTimeout;
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public static int getMaxLikeValueLength() {
        return maxLikeValueLength;
    }

    public static ZoneId getTimeZoneId() {
        return timeZoneId;
    }

    public static boolean isUseServerTranslateFilter() {
        return useServerTranslateFilter;
    }

    public static int getShardsNumber() {
        return shardsNumber;
    }

    public static int getReplicasNumber() {
        return replicasNumber;
    }

    public static int getBatchSplitCount() {
        return batchSplitCount;
    }

    public static boolean isTraceSlowQueryStack() {
        return traceSlowQueryStack;
    }

    public static boolean isEnableOptimization() {
        return enableOptimization;
    }

    public static boolean isOptimizationSetNowAsEnd() {
        return optimizationSetNowAsEnd;
    }

    static {
        ConfigurationUtil.observeString((String)"logorm.time_zone", (String)timeZone, v -> {
            timeZone = v;
            try {
                timeZoneId = ZoneId.of(timeZone);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ConfigurationUtil.observeInteger((String)"logorm.fetch_size", (int)fetchSize, v -> {
            fetchSize = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.query_timeout", (int)queryTimeout, v -> {
            queryTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.socket_timeout", (int)socketTimeout, v -> {
            socketTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.connection_timeout", (int)connectionTimeout, v -> {
            connectionTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.max_total_conn", (int)maxTotalConn, v -> {
            maxTotalConn = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.max_per_route_conn", (int)maxPerRouteConn, v -> {
            maxPerRouteConn = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.max_like_value_length", (int)maxLikeValueLength, v -> {
            maxLikeValueLength = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.shards_number", (int)shardsNumber, v -> {
            shardsNumber = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.replicas_number", (int)replicasNumber, v -> {
            replicasNumber = v;
        });
        ConfigurationUtil.observeInteger((String)"logorm.batch_split_count", (int)batchSplitCount, v -> {
            batchSplitCount = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.request.log.enable", (boolean)logElasticRequest, v -> {
            logElasticRequest = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.request.log.request_body", (boolean)logElasticRequestRequestBody, v -> {
            logElasticRequestRequestBody = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.request.log.response_body", (boolean)logElasticRequestResponseBody, v -> {
            logElasticRequestResponseBody = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.request.log.host", (boolean)logElasticRequestHost, v -> {
            logElasticRequestHost = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.use_server_translate_filter", (boolean)useServerTranslateFilter, v -> {
            useServerTranslateFilter = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.trace_slow_query_stack", (boolean)traceSlowQueryStack, v -> {
            traceSlowQueryStack = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.optimization.enable", (boolean)enableOptimization, v -> {
            enableOptimization = v;
        });
        ConfigurationUtil.observeBoolean((String)"logorm.optimization.set_now_as_end", (boolean)optimizationSetNowAsEnd, v -> {
            optimizationSetNowAsEnd = v;
        });
    }
}

