/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.datasource.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.HttpResponse;
import kd.bos.logorm.utils.HttpUtils;
import kd.bos.util.JSONUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ESConfig {
    private String schema;
    private ESCluster cluster;
    private String tenantId;
    private String accountId;
    private boolean enableElastic;
    private final Map<String, ArchiveESInfo> archiveHostInfo;

    public ESConfig(String schema, ESCluster cluster, Map<String, ArchiveESInfo> archiveHostInfo, String tenantId, String accountId, boolean enableElastic) {
        this.schema = schema;
        this.cluster = cluster;
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.enableElastic = enableElastic;
        this.archiveHostInfo = archiveHostInfo;
    }

    public String getSchema() {
        return this.schema;
    }

    public ESCluster getCluster() {
        return this.cluster;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean isEnableElastic() {
        return this.enableElastic;
    }

    public Map<String, ArchiveESInfo> getArchiveHostInfo() {
        return this.archiveHostInfo;
    }

    public static class ESInfo {
        private final String address;
        private final int port;
        private final String scheme;
        private final String name;
        private final String np1;

        public ESInfo(String address, int port, String scheme, String name, String np1) {
            if (scheme == null) {
                scheme = "http";
            }
            this.address = address;
            this.port = port;
            this.scheme = scheme;
            this.name = name;
            this.np1 = np1;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getName() {
            return this.name;
        }

        public String getNp1() {
            return this.np1;
        }
    }

    public static class URL {
        private final String schema;
        private final String host;
        private final int port;

        public URL(String schema, String host, int port) {
            this.schema = schema;
            this.host = host;
            this.port = port;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class ESCluster {
        private final String key;
        private final String number;
        private final String username;
        private final String np1;
        private final List<URL> urls = new ArrayList<URL>();

        public ESCluster(String key, String number, String username, String np1) {
            this.key = key;
            this.number = number;
            this.username = username;
            this.np1 = np1;
        }

        public void addURL(String schema, String host, int port) {
            this.urls.add(new URL(schema, host, port));
        }

        public String getKey() {
            return this.key;
        }

        public String getNumber() {
            return this.number;
        }

        public String getUsername() {
            return this.username;
        }

        public String getNp1() {
            return this.np1;
        }

        public List<URL> getUrls() {
            return this.urls;
        }

        public void check() {
            if (this.urls.isEmpty()) {
                throw LogORMExceptionFactory.createWithContext("cluster:" + this.number + " address info is empty.");
            }
            if (this.urls.size() == 1) {
                this.check0(this.urls.get(0));
            } else {
                String clusterUUID = this.check0(this.urls.get(0));
                for (int i = 1; i < this.urls.size(); ++i) {
                    if (clusterUUID.equals(this.check0(this.urls.get(i)))) continue;
                    throw LogORMExceptionFactory.createWithContext("address list not belong to one cluster, please check es cluster.");
                }
            }
        }

        private String check0(URL url) {
            SSLContext sslContext;
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(url.getHost(), url.getPort(), url.getSchema())});
            if ("https".equals(url.getSchema())) {
                try {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                }
                catch (Exception e) {
                    throw new KDException(BosErrorCode.dataSource, new Object[]{"Create SSLContext for ES HTTPS error"});
                }
            } else {
                sslContext = null;
            }
            if (this.username != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.np1));
                builder.setHttpClientConfigCallback(arg_0 -> ESCluster.lambda$check0$0(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
            }
            builder.setRequestConfigCallback(rcc -> {
                rcc.setConnectTimeout(LogORMConfig.getSocketTimeout());
                rcc.setSocketTimeout(LogORMConfig.getQueryTimeout());
                rcc.setConnectionRequestTimeout(LogORMConfig.getConnectionTimeout());
                return rcc;
            });
            RestClient client = builder.build();
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setClient(client);
            httpRequest.setRequestType(HttpRequest.RequestType.GET);
            httpRequest.setEndpoint("/");
            httpRequest.setContentType(HttpRequest.ContentType.JSON);
            HttpResponse response = HttpUtils.request(httpRequest);
            if (response.isOk()) {
                try {
                    Map map = (Map)JSONUtils.cast((String)response.getData(), Map.class);
                    return (String)map.get("cluster_uuid");
                }
                catch (IOException e) {
                    throw LogORMExceptionFactory.createWithContext("check elastic cluster:" + this.number + " error. error msg: " + e.getMessage(), e);
                }
            }
            throw LogORMExceptionFactory.createWithContext("please check elastic cluster:" + this.number + " config. error msg: " + response.getError().getMessage());
        }

        private static /* synthetic */ HttpAsyncClientBuilder lambda$check0$0(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder rcc) {
            rcc.setSSLContext(sslContext);
            rcc.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            rcc.setDefaultCredentialsProvider(credentialsProvider);
            rcc.setMaxConnPerRoute(LogORMConfig.getMaxPerRouteConn());
            rcc.setMaxConnTotal(LogORMConfig.getMaxTotalConn());
            return rcc;
        }
    }

    public static class ArchiveESInfo {
        private final String key;
        private final String name;
        private final ESCluster esCluster;

        public ArchiveESInfo(String key, String name, ESCluster esCluster) {
            this.key = key;
            this.name = name;
            this.esCluster = esCluster;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public ESCluster getEsCluster() {
            return this.esCluster;
        }
    }
}

