/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.datasource.es;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logorm.client.es.IndexExistManager;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.threads.ThreadPools;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class RestClientFactory {
    public static final String SCHEMA_PREFIX = "log-";
    public static final String ARCHIVE_SCHEMA_PREFIX = "log-archive-";
    private static final Map<String, ESDataSource> POOL = new ConcurrentHashMap<String, ESDataSource>();
    private static final Map<String, ESDataSource> ARCHIVE_POOL = new ConcurrentHashMap<String, ESDataSource>();
    private static final Map<String, ReentrantLock> invalidDataSourceLock = new ConcurrentHashMap<String, ReentrantLock>();

    private RestClientFactory() {
    }

    public static ESDataSource getClient(String tenantId, String accountId) {
        boolean notArchiveRequest = RestClientFactory.isNotArchiveRequest();
        String key = RestClientFactory.getKey(notArchiveRequest, tenantId, accountId);
        if (notArchiveRequest) {
            return POOL.computeIfAbsent(key, k -> RestClientFactory.getClient0(tenantId, accountId));
        }
        return ARCHIVE_POOL.computeIfAbsent(key, k -> RestClientFactory.getClient0(tenantId, accountId, RestClientFactory.getCurrentArchiveRouteKey()));
    }

    private static String getKey(boolean notArchiveRequest, String tenantId, String accountId) {
        return notArchiveRequest ? String.format("%s#%s", tenantId, accountId) : String.format("%s#%s#%s", tenantId, accountId, RestClientFactory.getCurrentArchiveRouteKey());
    }

    private static boolean isNotArchiveRequest() {
        if (ArchiveRoute.get() == null) {
            return true;
        }
        return "log".equalsIgnoreCase(RestClientFactory.getCurrentArchiveRouteKey());
    }

    private static String getCurrentArchiveRouteKey() {
        return ArchiveRoute.getMapRoute((String)"log");
    }

    private static ESDataSource config2DataSource(ESConfig.ESCluster cluster, String schema, boolean archive, String logicArchiveKey) {
        SSLContext sslContext;
        String name = cluster.getUsername();
        String np1 = cluster.getNp1();
        HttpHost[] httpHosts = new HttpHost[cluster.getUrls().size()];
        for (int i = 0; i < cluster.getUrls().size(); ++i) {
            httpHosts[i] = RestClientFactory.createHttpHost(cluster.getUrls().get(i));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if ("https".equals(httpHosts[0].getSchemeName())) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                sslContext = sslContextBuilder.build();
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.dataSource, new Object[]{"Create SSLContext for ES HTTPS error"});
            }
        } else {
            sslContext = null;
        }
        if (name != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(name, np1));
            builder.setHttpClientConfigCallback(arg_0 -> RestClientFactory.lambda$config2DataSource$2((CredentialsProvider)credentialsProvider, sslContext, arg_0));
        }
        builder.setNodeSelector(NodeSelector.SKIP_DEDICATED_MASTERS);
        builder.setRequestConfigCallback(rcc -> {
            rcc.setConnectTimeout(LogORMConfig.getSocketTimeout());
            rcc.setSocketTimeout(LogORMConfig.getQueryTimeout());
            rcc.setConnectionRequestTimeout(LogORMConfig.getConnectionTimeout());
            return rcc;
        });
        schema = !archive ? SCHEMA_PREFIX + schema : ARCHIVE_SCHEMA_PREFIX + schema + '-' + logicArchiveKey;
        return new ESDataSource(builder.build(), schema, archive, cluster);
    }

    private static ESDataSource getClient0(String tenantId, String accountId) {
        ESConfig config = MCApi.create().get(tenantId, accountId);
        ESConfig.ESCluster cluster = config.getCluster();
        if (cluster == null || cluster.getUrls().isEmpty()) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Not found ElasticSearch data source,rc:%s#%s", tenantId, accountId)});
        }
        return RestClientFactory.config2DataSource(cluster, config.getSchema(), false, null);
    }

    private static ESDataSource getClient0(String tenantId, String accountId, String archiveRouteKey) {
        ESConfig config = MCApi.create().get(tenantId, accountId);
        Map<String, ESConfig.ArchiveESInfo> archiveMap = config.getArchiveHostInfo();
        if (archiveMap.isEmpty()) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Archive route dataSource not found,rc:%s#%s", tenantId, accountId)});
        }
        int indexLg = archiveRouteKey.indexOf("$");
        String realArchiveKey = archiveRouteKey.substring(0, indexLg);
        String logicSuffix = archiveRouteKey.substring(indexLg);
        ESConfig.ESCluster esCluster = archiveMap.get(realArchiveKey).getEsCluster();
        if (esCluster == null || esCluster.getUrls().isEmpty()) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Not found elastic archive data source,rc:%s#%s", tenantId, accountId)});
        }
        return RestClientFactory.config2DataSource(esCluster, config.getSchema(), true, logicSuffix);
    }

    private static HttpHost createHttpHost(ESConfig.URL url) {
        return new HttpHost(url.getHost(), url.getPort(), url.getSchema());
    }

    public static void clearCache() {
        HashSet<ESDataSource> destroy = new HashSet<ESDataSource>();
        destroy.addAll(POOL.values());
        destroy.addAll(ARCHIVE_POOL.values());
        IndexExistManager.clearIndexExistCache();
        POOL.clear();
        ARCHIVE_POOL.clear();
        IndexExistManager.clearIndexExistCache();
        ThreadPools.executeOnce((String)"LogORM-CloseDataSource", () -> {
            for (ESDataSource esDataSource : destroy) {
                RestClientFactory.closeDataSource(esDataSource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidDataSource(String tenantId, String accountId) {
        ReentrantLock lock = invalidDataSourceLock.computeIfAbsent(String.format("%s#%s", tenantId, accountId), k -> new ReentrantLock());
        try {
            boolean locked = lock.tryLock();
            if (!locked) {
                return;
            }
            String key = RestClientFactory.getKey(true, tenantId, accountId);
            ESDataSource ds = POOL.remove(key);
            RestClientFactory.closeDataSource(ds);
            key = RestClientFactory.getKey(false, tenantId, accountId);
            ds = ARCHIVE_POOL.remove(key);
            RestClientFactory.closeDataSource(ds);
        }
        finally {
            lock.unlock();
        }
    }

    private static void closeDataSource(ESDataSource dataSource) {
        if (dataSource != null) {
            dataSource.close();
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$config2DataSource$2(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder rcc) {
        rcc.setDefaultCredentialsProvider(credentialsProvider);
        rcc.setSSLContext(sslContext);
        rcc.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        rcc.setMaxConnPerRoute(LogORMConfig.getMaxPerRouteConn());
        rcc.setMaxConnTotal(LogORMConfig.getMaxTotalConn());
        return rcc;
    }
}

