/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.exception;

import kd.bos.db.RequestContextInfo;
import kd.bos.logorm.exception.LogORMException;
import kd.bos.logorm.exception.LogORMWarnException;

public class LogORMExceptionFactory {
    private LogORMExceptionFactory() {
    }

    public static LogORMWarnException createWarn(String msg) {
        return new LogORMWarnException(msg);
    }

    public static LogORMWarnException createWarn(String msg, Object ... args) {
        return new LogORMWarnException(String.format(msg, args));
    }

    public static LogORMException create(String msg) {
        return new LogORMException(msg);
    }

    public static LogORMException create(String msg, Object ... args) {
        return new LogORMException(String.format(msg, args));
    }

    public static LogORMException create(Throwable throwable, String msg, Object ... args) {
        return new LogORMException(String.format(msg, args), throwable);
    }

    public static LogORMException create(String msg, Throwable throwable) {
        return new LogORMException(msg, throwable);
    }

    public static LogORMException createWithContext(String msg) {
        return new LogORMException(LogORMExceptionFactory.wrapperWithContext(msg));
    }

    public static LogORMException createWithContext(String msg, Throwable throwable) {
        return new LogORMException(LogORMExceptionFactory.wrapperWithContext(msg), throwable);
    }

    public static LogORMException createWithContext(String msg, Object ... args) {
        return new LogORMException(LogORMExceptionFactory.wrapperWithContext(String.format(msg, args)));
    }

    public static LogORMException createWithContext(Throwable throwable, String msg, Object ... args) {
        return new LogORMException(LogORMExceptionFactory.wrapperWithContext(String.format(msg, args)), throwable);
    }

    private static String wrapperWithContext(String msg) {
        try {
            RequestContextInfo current = RequestContextInfo.get();
            String contextString = "\nRequestContext:" + current.getTenantId() + "#" + current.getAccountId();
            return msg + contextString;
        }
        catch (Exception ex) {
            return msg;
        }
    }
}

