/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.IFunction;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.impl.ORMEntityInvoker;
import kd.bos.xdb.util.Pair;

class DataEntityMetaProviderImpl
implements DataEntityMetaProvider {
    private final ORMEntityInvoker ormEntityInvoker;
    private final Map<String, Pair<DynamicObjectType, DataEntityTypeMap>> typeCache = new HashMap<String, Pair<DynamicObjectType, DataEntityTypeMap>>();
    private final Map<String, EntityMetadataContext> entityMetadataMap = new HashMap<String, EntityMetadataContext>();
    private final Function<String, EntityMetadataContext> entityMetadataProvider;

    public DataEntityMetaProviderImpl() {
        this.entityMetadataProvider = this::initEntityMetadata;
        try {
            this.ormEntityInvoker = (ORMEntityInvoker)Class.forName("kd.bos.entity.query.ORMEntityInvokerImpl").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw LogORMExceptionFactory.create(e, "ORMEntityInvoker init fail,detail message: %s", e.getMessage());
        }
    }

    public DataEntityMetaProviderImpl(ORMEntityInvoker ormEntityInvoker, Function<String, EntityMetadataContext> entityMetadataProvider) {
        this.ormEntityInvoker = ormEntityInvoker;
        this.entityMetadataProvider = entityMetadataProvider;
    }

    @Override
    public DynamicObjectType getDynamicObjectType(String entityName) {
        Pair<DynamicObjectType, DataEntityTypeMap> metaPair = this.getDynamicObjectMetaPair(entityName);
        return (DynamicObjectType)metaPair.getKey();
    }

    private Pair<DynamicObjectType, DataEntityTypeMap> getDynamicObjectMetaPair(String entityName) {
        Pair metaPair = this.typeCache.get(entityName);
        if (metaPair != null) {
            return metaPair;
        }
        DynamicObjectType dot = this.ormEntityInvoker.getDataEntityType(entityName);
        if (dot == null) {
            throw LogORMExceptionFactory.createWithContext("Entity name: %s doesn't exist.", entityName);
        }
        RefObject tempRefDb = new RefObject(null);
        DataEntityTypeMap detm = DataEntityTypeMap.Build((IDataEntityType)dot, (RefObject)tempRefDb);
        metaPair = new Pair((Object)dot, (Object)detm);
        this.typeCache.put(entityName, (Pair<DynamicObjectType, DataEntityTypeMap>)metaPair);
        return metaPair;
    }

    @Override
    public EntityMetadataContext getEntityMetadata(String entityName) {
        EntityMetadataContext metadata = this.entityMetadataMap.get(entityName);
        if (metadata == null) {
            metadata = this.entityMetadataProvider.apply(entityName);
            this.entityMetadataMap.put(entityName, metadata);
        }
        return metadata;
    }

    private EntityMetadataContext initEntityMetadata(String entityName) {
        Pair<DynamicObjectType, DataEntityTypeMap> metaPair = this.getDynamicObjectMetaPair(entityName);
        DataEntityPropertyCollection ormDataEntityPropertyCollection = ((DynamicObjectType)metaPair.getKey()).getProperties();
        DbMetadataColumnCollection dbColumns = ((DataEntityTypeMap)metaPair.getValue()).getDbTable().getColumns();
        HashSet<String> largeTextPropertyContain = new HashSet<String>(8);
        for (IDataEntityProperty property : ormDataEntityPropertyCollection) {
            try {
                if (!Class.forName("kd.bos.entity.property.LargeTextProp").isInstance(property)) continue;
                largeTextPropertyContain.add(property.getName().toLowerCase() + "_tag");
            }
            catch (Exception e) {
                throw LogORMExceptionFactory.createWithContext(e.getMessage(), e);
            }
        }
        ArrayList<EntityProperty> props = new ArrayList<EntityProperty>(ormDataEntityPropertyCollection.size());
        for (int i = 0; i < ormDataEntityPropertyCollection.size(); ++i) {
            IDataEntityProperty property = (IDataEntityProperty)ormDataEntityPropertyCollection.get(i);
            String alias = property.getAlias();
            if (alias == null || alias.trim().isEmpty()) continue;
            DbMetadataColumn column = (DbMetadataColumn)dbColumns.getItem(alias);
            IFunction convert = CRUDHelper.getConverterByColumn((DbMetadataColumn)column);
            Supplier<Object> defaultValueGetter = null;
            if (column.getDefaultValue() != null) {
                defaultValueGetter = convert == null ? () -> ((DbMetadataColumn)column).getDefaultValue() : () -> convert.apply(column.getDefaultValue());
            }
            int dbType = column.getDbType();
            String propertyName = property.getName();
            if (propertyName.endsWith("_tag") && largeTextPropertyContain.contains(propertyName.toLowerCase())) {
                dbType = 2011;
            }
            props.add(new EntityProperty(propertyName, property.getAlias(), dbType, property.getOrdinal(), (IFunction<Object, Object>)convert, defaultValueGetter, column));
        }
        String tableName = ((DynamicObjectType)metaPair.getKey()).getAlias();
        if ("".equals(tableName)) {
            throw LogORMExceptionFactory.createWithContext("Entity '%s' table name can not be null or empty.", entityName);
        }
        tableName = tableName.toLowerCase();
        return new EntityMetadataContext(entityName, tableName, props.toArray(new EntityProperty[0]));
    }
}

