/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.RequestContextInfo;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.logorm.impl.LogORMDBImpl;
import kd.bos.logorm.impl.LogORMElasticImpl;
import kd.bos.logorm.impl.LogORMImplContext;

public class LogORMFactory {
    private LogORMFactory() {
    }

    public static LogORM create(String entityName) {
        return LogORMFactory.create();
    }

    public static LogORM create(List<DynamicObject> dynamicObjects) {
        return LogORMFactory.create();
    }

    public static LogORM create() {
        LogORM instance = LogORMFactory.createByContext();
        if (instance != null) {
            return instance;
        }
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (MCApi.create().enableElastic(tenantId, accountId)) {
            return new LogORMElasticImpl();
        }
        return new LogORMDBImpl();
    }

    private static LogORM createByContext() {
        return LogORMImplContext.get();
    }
}

