/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.metric;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Reservoir;
import java.util.List;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.metric.FixedLengthSortList;
import kd.bos.logorm.metric.LogORMCostMetric;
import kd.bos.logorm.metric.LogORMMXBeanImpl;
import kd.bos.logorm.metric.LogORMMetricService;
import kd.bos.logorm.metric.QuerySlowSnapshot;
import kd.bos.metric.Histogram;
import kd.bos.util.DisCardUtil;

public class LogORMMetricServiceImpl
implements LogORMMetricService {
    private final Histogram queryHistogram = new Histogram(new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir()));
    private final Histogram insertHistogram = new Histogram(new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir()));
    private final Histogram updateHistogram = new Histogram(new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir()));
    private final Histogram deleteHistogram = new Histogram(new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir()));
    private final FixedLengthSortList<QuerySlowSnapshot> slowQuery = new FixedLengthSortList(10, 1000);
    private static final LogORMMetricServiceImpl INSTANCE = new LogORMMetricServiceImpl();

    public static LogORMMetricServiceImpl getINSTANCE() {
        return INSTANCE;
    }

    public LogORMMetricServiceImpl() {
        try {
            new LogORMMXBeanImpl(this);
        }
        catch (Exception ignored) {
            DisCardUtil.discard();
        }
    }

    @Override
    public LogORMCostMetric queryMetric(String entityName) {
        if (!LogORMConfig.isTraceSlowQueryStack()) {
            return new LogORMCostMetric(this.queryHistogram);
        }
        return new LogORMCostMetric(this.queryHistogram, metric -> {
            RuntimeException stack = new RuntimeException("LogORM-Slow-Stack: " + entityName + " query cost:" + metric.getCost() + "ms.");
            this.slowQuery.add(new QuerySlowSnapshot(entityName, stack, metric.getCost()));
        });
    }

    @Override
    public LogORMCostMetric insertMetric() {
        return new LogORMCostMetric(this.insertHistogram);
    }

    @Override
    public LogORMCostMetric updateMetric() {
        return new LogORMCostMetric(this.updateHistogram);
    }

    @Override
    public LogORMCostMetric deleteMetric() {
        return new LogORMCostMetric(this.deleteHistogram);
    }

    @Override
    public List<QuerySlowSnapshot> getSlowQueryTop10() {
        return this.slowQuery.getTop();
    }

    public Histogram getQueryHistogram() {
        return this.queryHistogram;
    }

    public Histogram getInsertHistogram() {
        return this.insertHistogram;
    }

    public Histogram getUpdateHistogram() {
        return this.updateHistogram;
    }

    public Histogram getDeleteHistogram() {
        return this.deleteHistogram;
    }
}

