/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.utils.ObjectTypeUtils;

public class EachUtils {
    private EachUtils() {
    }

    public static List<Object> eachArrayOrCollection(Object object, Function<Object, Object> handleItem) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<Object> result = new ArrayList<Object>(collection.size());
            for (Object value : collection) {
                result.add(handleItem.apply(value));
            }
            return result;
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            ArrayList<Object> result = new ArrayList<Object>(128);
            for (Object value : iterable) {
                result.add(handleItem.apply(value));
            }
            return result;
        }
        if (object.getClass().isArray()) {
            return EachUtils.eachArray(object, handleItem);
        }
        return Lists.newArrayList((Object[])new Object[]{handleItem.apply(object)});
    }

    private static List<Object> eachArray(Object o, Function<Object, Object> handleItem) {
        ArrayList<Object> result;
        if (o instanceof int[]) {
            int[] array = (int[])o;
            result = new ArrayList<Object>(array.length);
            for (int i : array) {
                result.add(handleItem.apply(i));
            }
        } else if (o instanceof long[]) {
            long[] array = (long[])o;
            result = new ArrayList(array.length);
            for (long i : array) {
                result.add(handleItem.apply(i));
            }
        } else if (o instanceof float[]) {
            float[] array = (float[])o;
            result = new ArrayList(array.length);
            for (float i : array) {
                result.add(handleItem.apply(Float.valueOf(i)));
            }
        } else if (o instanceof double[]) {
            double[] array = (double[])o;
            result = new ArrayList(array.length);
            for (double i : array) {
                result.add(handleItem.apply(i));
            }
        } else if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            result = new ArrayList(array.length);
            for (Object i : array) {
                result.add(handleItem.apply(i));
            }
        } else {
            throw LogORMExceptionFactory.create("Unsupported array param type: %s", ObjectTypeUtils.getTypeName(o));
        }
        return result;
    }
}

