/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;

public class HttpRequest {
    private RestClient client;
    private String endpoint;
    private RequestType requestType;
    private ContentType contentType;
    private String data;
    private Map<String, String> header;
    private Map<String, String> params;
    private int socketTimeout = 300;
    private int connectTimeoutSeconds = 60;

    public String getEndpoint() {
        return this.endpoint;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    public RestClient getClient() {
        return this.client;
    }

    public void setClient(RestClient client) {
        this.client = client;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Request getESRequest() throws IOException {
        Request inner = new Request(this.requestType.name(), this.endpoint);
        RequestOptions.Builder reqOpsBuilder = RequestOptions.DEFAULT.toBuilder();
        if (this.header != null) {
            this.header.forEach((arg_0, arg_1) -> ((RequestOptions.Builder)reqOpsBuilder).addHeader(arg_0, arg_1));
            inner.setOptions(reqOpsBuilder);
        }
        if (this.params != null) {
            this.params.forEach((arg_0, arg_1) -> ((Request)inner).addParameter(arg_0, arg_1));
        }
        inner.setJsonEntity(this.data);
        return inner;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("endpoint:").append(this.endpoint).append("\r\n");
        builder.append("queryParam:").append(this.map2String("&", this.params)).append("\r\n");
        builder.append("headers:").append(this.map2String(";", this.header)).append("\r\n");
        builder.append("body:\r\n").append(this.data);
        return builder.toString();
    }

    private String map2String(String delimiter, Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "null";
        }
        ArrayList kvs = new ArrayList(map.size());
        map.forEach((k, v) -> kvs.add(k + "=" + v));
        return String.join((CharSequence)delimiter, kvs);
    }

    public String getData() {
        return this.data;
    }

    public static enum ContentType {
        JSON;

    }

    public static enum RequestType {
        PUT,
        GET,
        POST,
        HEAD;

    }
}

