/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.utils;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.id.ID;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class PresetPropertyUtils {
    private PresetPropertyUtils() {
    }

    public static void checkPK(List<DynamicObject> objects) {
        if (!objects.isEmpty()) {
            DynamicObjectType dt = objects.get(0).getDynamicObjectType();
            ISimpleProperty primaryKeyProperty = dt.getPrimaryKey();
            for (int i = 0; i < objects.size(); ++i) {
                DynamicObject object = objects.get(i);
                Object primary = primaryKeyProperty.getValueFast((Object)object);
                if (primary != null && !Long.valueOf(0L).equals(primary)) continue;
                throw LogORMExceptionFactory.createWithContext("Batch update fail, row:%d pk is null.", i);
            }
        }
    }

    public static void setPKIfNoExist(List<DynamicObject> objects) {
        if (!objects.isEmpty()) {
            DynamicObjectType dt = objects.get(0).getDynamicObjectType();
            ISimpleProperty primaryKeyProperty = dt.getPrimaryKey();
            for (DynamicObject object : objects) {
                Object primary = primaryKeyProperty.getValueFast((Object)object);
                if (primary != null && !Long.valueOf(0L).equals(primary)) continue;
                primaryKeyProperty.setValueFast((Object)object, (Object)ID.genLongId());
            }
        }
    }

    public static void setOpDateIfNotExist(List<DynamicObject> objects) {
        if (!objects.isEmpty()) {
            DynamicObjectType dt = objects.get(0).getDynamicObjectType();
            ISimpleProperty primaryKeyProperty = (ISimpleProperty)dt.getProperty("opdate");
            for (DynamicObject object : objects) {
                Object primary = primaryKeyProperty.getValueFast((Object)object);
                if (primary != null) continue;
                primaryKeyProperty.setValueFast((Object)object, (Object)new Date());
            }
        }
    }

    public static Date getOpDate(DynamicObject dynamicObject) {
        return dynamicObject.getDate("opdate");
    }

    public static String getSortColumnName() {
        return "fopdate";
    }

    public static String getSortPropertyName() {
        return "opdate";
    }
}

