/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha;

import java.io.StringReader;
import java.util.Properties;
import kd.bos.framework.lifecycle.Service;
import kd.bos.ha.config.HaConfigFactory;
import kd.bos.ha.http.service.HAHttpRegisty;
import kd.bos.ha.http.service.api.HAEyeHttpRegister;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.core.MetricReporter;
import kd.bos.threads.ThreadPools;

public class HAService
implements Service {
    private static Log logger = LogFactory.getLog(HAService.class);
    private static final String CONFIG_KEY_MONITOR = "ha.watch.monitor";
    private volatile boolean isStartedFlag = false;

    public String getName() {
        return "HAService";
    }

    public boolean isStarted() {
        return this.isStartedFlag;
    }

    public void start() {
        ThreadPools.executeOnce((String)"HAService-start", () -> {
            if (this.isStartedFlag) {
                return;
            }
            HAHttpRegisty.register();
            HAEyeHttpRegister.register();
            if (HaConfigFactory.createHaConfig().isEnable()) {
                WatchServer.getInstance().start();
                MetricReporter.startHAWatch();
                this.isStartedFlag = true;
                logger.info("HaWatchService Started successfully");
            }
        });
    }

    public void stop() {
        if (!this.isStartedFlag) {
            return;
        }
        if (this.getWatchIsEnabled()) {
            WatchServer.getInstance().stop();
            MetricReporter.stopHAWatch();
            this.isStartedFlag = false;
            logger.info("HaWatchService Stopped");
        }
    }

    private boolean getWatchIsEnabled() {
        String config = System.getProperty(CONFIG_KEY_MONITOR);
        try {
            if (config == null) {
                return false;
            }
            Properties props = new Properties();
            props.load(new StringReader(config));
            boolean retval = Boolean.parseBoolean(props.getProperty("enable", "false"));
            return retval;
        }
        catch (Exception ex) {
            logger.error("HaWatchService-ha.watch.monitor configure error:" + ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

