/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.alarm.config.AlarmConfigUtils;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class AbstractJsonParse {
    private static boolean isMCInitialized = AbstractJsonParse.getInitialized();
    private static Log logger = LogFactory.getLog(AbstractJsonParse.class);

    public static boolean isMCInitialized() {
        return isMCInitialized;
    }

    public static void setMCInitialized(boolean mcInitialized) {
        isMCInitialized = mcInitialized;
    }

    protected static boolean getInitialized() {
        try {
            return AlarmConfigUtils.isInitialized();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    public static List<Alarm> jsonToAlarmList(String alarmListJson, String actionListJson) throws IOException {
        List lstActionRef = null;
        if (!StringUtils.isEmpty((String)actionListJson)) {
            lstActionRef = (List)JSONUtils.cast((String)actionListJson, (boolean)true, List.class, (Class[])new Class[]{Action.class});
        }
        String newAlarmJson = AbstractJsonParse.getCompatibleAlarmList(alarmListJson);
        List lstAlarms = (List)JSONUtils.cast((String)newAlarmJson, (boolean)true, List.class, (Class[])new Class[]{Alarm.class});
        for (Alarm alarm : lstAlarms) {
            if (alarm.getActions() == null) {
                alarm.setActions(new ArrayList<Action>());
            }
            if (alarm.getActionRefs() != null) {
                for (String actionRefName : alarm.getActionRefs()) {
                    Action action = AbstractJsonParse.getActionRefByActionType(lstActionRef, actionRefName);
                    if (action == null) {
                        throw new RuntimeException("Cannot found action:" + actionRefName + " in actionlist");
                    }
                    alarm.getActions().add(action);
                }
            }
            for (Action action : alarm.getActions()) {
                action.setAlarmName(alarm.getName());
                action.setCategory(alarm.getCategory());
                action.setMetricName(alarm.getMetricName());
            }
        }
        return lstAlarms;
    }

    private static String getCompatibleAlarmList(String json) {
        String newJson = json.replace("slientPeriod", "silentPeriod");
        return newJson;
    }

    private static Action getActionRefByActionType(List<Action> lstActionRef, String actionType) {
        if (lstActionRef == null || lstActionRef.size() == 0) {
            return null;
        }
        for (Action action : lstActionRef) {
            if (!actionType.equals(action.getActionType())) continue;
            return action;
        }
        return null;
    }
}

