/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.config.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.alarm.config.AlarmConfigListener;
import kd.bos.eye.api.alarm.config.AlarmConfigUtils;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.ha.config.AbstractJsonParse;
import kd.bos.ha.config.HaConfig;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.core.MetricReporter;
import kd.bos.util.StringUtils;

public class HaMonitorConfig
implements HaConfig {
    private static boolean enabled = false;
    private static int interval = 15;
    private static List<Alarm> alarmList = null;
    private static Log logger = LogFactory.getLog(HaMonitorConfig.class);

    public HaMonitorConfig() {
        try {
            HaMonitorConfig.initListener();
            if (DBHelper.dbIsConfigured()) {
                HaMonitorConfig.initEnabled();
                HaMonitorConfig.initInterval();
                HaMonitorConfig.initAlarmList();
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private static void initAlarmList() {
        String alarmJson = AlarmConfigUtils.getAlarmListJson();
        String actionListJson = AlarmConfigUtils.getActionListJson();
        if (StringUtils.isEmpty((String)alarmJson)) {
            alarmList = new ArrayList<Alarm>(0);
            return;
        }
        try {
            alarmList = AbstractJsonParse.jsonToAlarmList(alarmJson, actionListJson);
        }
        catch (Exception e) {
            logger.error("HaWatch--Get Alarm data from json have an exception,json: " + alarmJson, (Throwable)e);
        }
    }

    private static void initInterval() {
        interval = AlarmConfigUtils.getIntervalSecondes();
    }

    private static void initEnabled() {
        enabled = AlarmConfigUtils.isEnable();
    }

    @Override
    public boolean isEnable() {
        return enabled;
    }

    @Override
    public int getInterval() {
        return interval;
    }

    @Override
    public List<Alarm> getAlarmList() {
        return alarmList;
    }

    private static void initListener() {
        AlarmConfigUtils.addAlarmConfigListener((AlarmConfigListener)new AlarmConfigListener(){

            public void configChanged(String key, String value) {
                if ("ha.mc.config.init".equals(key)) {
                    AbstractJsonParse.setMCInitialized("true".equalsIgnoreCase(value));
                } else {
                    if (!AbstractJsonParse.isMCInitialized()) {
                        return;
                    }
                    if ("ha.monitor.config.enable".equals(key)) {
                        HaMonitorConfig.initEnabled();
                        if (enabled) {
                            WatchServer.getInstance().start();
                            MetricReporter.startHAWatch();
                        } else {
                            WatchServer.getInstance().stop();
                            MetricReporter.stopHAWatch();
                        }
                    } else if ("ha.monitor.config.interval".equals(key)) {
                        HaMonitorConfig.initInterval();
                    } else if ("ha.monitor.config.alarmList".equals(key) || "ha.monitor.config.actionList".equals(key)) {
                        HaMonitorConfig.initAlarmList();
                        WatchServer.getInstance().getMetaStore().reloadMetaData();
                    }
                }
            }
        });
    }
}

