/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.util.JmxUtils;
import kd.bos.util.StringUtils;

public class ServiceStatusManage {
    private static final Log log = LogFactory.getLog(ServiceStatusManage.class);
    private static final String COUNT = "Count";
    private static final String VALUE = "Value";
    private static final String DUBBO_MAX = "kd.metrics:name=kd.metrics.dubbo.maxThreads,type=gauges";
    private static final String WEB_TIMEOUTS = "kd.metrics:name=kd.metrics.servletfilter.timeouts,type=meters";
    private static final String WEB_ERRORS = "kd.metrics:name=kd.metrics.servletfilter.errors,type=meters";
    private static final String MQ_MAX = "kd.metrics:name=kd.metrics.mq.consumer.Counter,type=counters";
    private static final String MQ = "kd.metrics:name=kd.metrics.mq.consumer.activeConsumers,type=counters";
    private static final String SCHEDULE = "kd.metrics:name=kd.metrics.schedule.consumer.activeThreads,type=counters";
    private static final String SCHEDULE_MAX = "kd.metrics:name=kd.metrics.schedule.consumer.maxThreads,type=counters";
    private static final String DUBBO = "kd.metrics:name=kd.metrics.dubbo.provider.activeRequests,type=counters";
    private static final String FEIGN = "kd.metrics:name=kd.metrics.feign.provider.activeRequests,type=counters";
    private static final String WEB = "kd.metrics:name=kd.metrics.servletfilter.activeRequests,type=counters";
    private static final String SERVICE_NAME_TAG = "serviceName";
    private static final String ACTIVE_THREAD_TAG = "activeThread";
    private static final String MAX_THREAD_TAG = "maxThread";
    private static final String SCROLL_RESTART_PATH = "/runtime/monitor/GracefulRestart";

    public static List<Map<String, Object>> getServiceStatus() {
        Object dubboActive;
        HashMap<String, Object> dubbo;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(3);
        HashMap<String, Object> web = new HashMap<String, Object>(3);
        web.put(SERVICE_NAME_TAG, "webRequest");
        Object webActive = JmxUtils.getAtt((String)WEB, (String)COUNT);
        web.put(ACTIVE_THREAD_TAG, webActive);
        Object webError = JmxUtils.getAtt((String)WEB_ERRORS, (String)COUNT);
        Object webTimeout = JmxUtils.getAtt((String)WEB_TIMEOUTS, (String)COUNT);
        long max = 0L;
        if (webError instanceof Long && webTimeout instanceof Long && webActive instanceof Long) {
            max = (Long)webError + (Long)webTimeout + (Long)webActive;
        }
        web.put(MAX_THREAD_TAG, max);
        list.add(web);
        HashMap<String, Object> mq = new HashMap<String, Object>(3);
        mq.put(SERVICE_NAME_TAG, "mqRequest");
        webActive = JmxUtils.getAtt((String)MQ, (String)COUNT);
        mq.put(ACTIVE_THREAD_TAG, webActive);
        mq.put(MAX_THREAD_TAG, JmxUtils.getAtt((String)MQ_MAX, (String)COUNT));
        list.add(mq);
        if ("dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            dubbo = new HashMap<String, Object>(3);
            dubbo.put(SERVICE_NAME_TAG, "dubboRequest");
            dubboActive = JmxUtils.getAtt((String)DUBBO, (String)COUNT);
            dubbo.put(ACTIVE_THREAD_TAG, dubboActive);
            dubbo.put(MAX_THREAD_TAG, JmxUtils.getAtt((String)DUBBO_MAX, (String)VALUE));
            list.add(dubbo);
        } else if ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            HashMap<String, Object> feign = new HashMap<String, Object>(3);
            feign.put(SERVICE_NAME_TAG, "feignRequest");
            Object feignActive = JmxUtils.getAtt((String)FEIGN, (String)COUNT);
            feign.put(ACTIVE_THREAD_TAG, feignActive);
            list.add(feign);
        } else {
            dubbo = new HashMap(3);
            dubbo.put(SERVICE_NAME_TAG, "dubboRequest");
            dubboActive = JmxUtils.getAtt((String)DUBBO, (String)COUNT);
            dubbo.put(ACTIVE_THREAD_TAG, dubboActive);
            dubbo.put(MAX_THREAD_TAG, JmxUtils.getAtt((String)DUBBO_MAX, (String)VALUE));
            list.add(dubbo);
            HashMap<String, Object> feign = new HashMap<String, Object>(3);
            feign.put(SERVICE_NAME_TAG, "feignRequest");
            Object feignActive = JmxUtils.getAtt((String)FEIGN, (String)COUNT);
            feign.put(ACTIVE_THREAD_TAG, feignActive);
            list.add(feign);
        }
        mq = new HashMap(3);
        mq.put(SERVICE_NAME_TAG, "scheduleRequest");
        webActive = JmxUtils.getAtt((String)SCHEDULE, (String)COUNT);
        mq.put(ACTIVE_THREAD_TAG, webActive);
        mq.put(MAX_THREAD_TAG, JmxUtils.getAtt((String)SCHEDULE_MAX, (String)COUNT));
        list.add(mq);
        return list;
    }

    public static boolean isRollingRestarting() {
        return ServiceStatusManage.isRollingRestarting(Instance.getAppName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRollingRestarting(String appName, boolean isCreat) {
        Class<ServiceStatusManage> clazz = ServiceStatusManage.class;
        synchronized (ServiceStatusManage.class) {
            try {
                ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
                if (!messageCenter.existsNode("gov.zk.url", ServiceStatusManage.getPath(""), appName)) {
                    if (isCreat) {
                        messageCenter.setNode("gov.zk.url", ServiceStatusManage.getPath(""), appName, "rolling");
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            catch (Exception e) {
                log.warn("\u6eda\u52a8\u91cd\u542f-\u521b\u5efa\u4f18\u96c5\u91cd\u542f\u72b6\u6001\u6807\u8bc6\u4f4d\u5931\u8d25\uff1a", (Throwable)e);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
        }
    }

    public static List<String> getScrollRestartingServers() {
        try {
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            return messageCenter.getChildrenNames("gov.zk.url", ServiceStatusManage.getPath(""));
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u6eda\u52a8\u91cd\u542f\u4e2d\u7684\u6240\u6709\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRollingRestartStatus(String appName) {
        try {
            Class<ServiceStatusManage> clazz = ServiceStatusManage.class;
            synchronized (ServiceStatusManage.class) {
                ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
                messageCenter.deleteNode("gov.zk.url", ServiceStatusManage.getPath(appName), "");
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            log.warn("\u5220\u9664\u4f18\u96c5\u91cd\u542f\u72b6\u6001\u6807\u8bc6\u4f4d\u5931\u8d25\uff1a", (Throwable)e);
        }
        {
            return;
        }
    }

    private static String getPath(String appName) {
        if (StringUtils.isNotEmpty((String)appName)) {
            appName = appName.replaceAll("/", "");
            return Instance.getClusterName() + SCROLL_RESTART_PATH + "/" + appName;
        }
        return Instance.getClusterName() + SCROLL_RESTART_PATH;
    }
}

